/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.state.transition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.fsm.state.transition.AbstractStateTransition;
import org.neo4j.bolt.fsm.state.transition.StateTransition;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;

final class SequentialStateTransition<R extends RequestMessage>
extends AbstractStateTransition<R> {
    private final boolean passLastResult;
    private final List<StateTransition<? super R>> transitions;

    public SequentialStateTransition(Class<R> requestType, boolean passLastResult, List<StateTransition<? super R>> transitions) {
        super(requestType);
        if (transitions.size() < 2) {
            throw new IllegalArgumentException("Must provide at least two transitions");
        }
        this.passLastResult = passLastResult;
        this.transitions = new ArrayList<StateTransition<R>>(transitions);
    }

    public SequentialStateTransition(Class<R> requestType, boolean passLastResult, StateTransition<? super R> ... transitions) {
        super(requestType);
        if (transitions.length < 2) {
            throw new IllegalArgumentException("Must provide at least two transitions");
        }
        this.passLastResult = passLastResult;
        this.transitions = Arrays.asList(transitions);
    }

    @Override
    public StateReference process(Context ctx, R message, ResponseHandler handler) throws StateMachineException {
        StateReference result = null;
        Iterator<StateTransition<R>> it = this.transitions.iterator();
        do {
            StateTransition<R> transition = it.next();
            StateReference newResult = transition.process(ctx, message, handler);
            if (result != null && !this.passLastResult) continue;
            result = newResult;
        } while (it.hasNext());
        return result;
    }
}

