/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.error.reader;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.io.Type;
import org.neo4j.packstream.io.TypeMarker;

public class UnexpectedTypeException
extends PackstreamReaderException
implements Status.HasStatus,
ErrorGqlStatusObject {
    private final Type expected;
    private final Type actual;
    private final ErrorGqlStatusObject gqlStatusObject;
    private final String oldMessage;

    public UnexpectedTypeException(Type expected, Type actual) {
        super("Unexpected type: Expected " + expected + " but got " + actual);
        this.expected = expected;
        this.actual = actual;
        this.gqlStatusObject = null;
        this.oldMessage = "Unexpected type: Expected " + expected + " but got " + actual;
    }

    public UnexpectedTypeException(ErrorGqlStatusObject gqlStatusObject, Type expected, Type actual) {
        super(ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gqlStatusObject, (String)("Unexpected type: Expected " + expected + " but got " + actual)));
        this.gqlStatusObject = gqlStatusObject;
        this.expected = expected;
        this.actual = actual;
        this.oldMessage = "Unexpected type: Expected " + expected + " but got " + actual;
    }

    public UnexpectedTypeException(Type actual) {
        super("Unexpected type: " + actual);
        this.expected = null;
        this.actual = actual;
        this.gqlStatusObject = null;
        this.oldMessage = "Unexpected type: " + actual;
    }

    public UnexpectedTypeException(ErrorGqlStatusObject gqlStatusObject, Type actual) {
        super(ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gqlStatusObject, (String)("Unexpected type: " + actual)));
        this.gqlStatusObject = gqlStatusObject;
        this.expected = null;
        this.actual = actual;
        this.oldMessage = "Unexpected type: " + actual;
    }

    public UnexpectedTypeException(Type expected, TypeMarker actual) {
        this(expected, actual.getType());
    }

    public UnexpectedTypeException(ErrorGqlStatusObject gqlStatusObject, Type expected, TypeMarker actual) {
        this(gqlStatusObject, expected, actual.getType());
    }

    protected UnexpectedTypeException(String message, Type expected, Type actual) {
        super(message);
        this.expected = expected;
        this.actual = actual;
        this.gqlStatusObject = null;
        this.oldMessage = message;
    }

    protected UnexpectedTypeException(ErrorGqlStatusObject gqlStatusObject, String message, Type expected, Type actual) {
        super(ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gqlStatusObject, (String)message));
        this.gqlStatusObject = gqlStatusObject;
        this.expected = expected;
        this.actual = actual;
        this.oldMessage = message;
    }

    public Type getExpected() {
        return this.expected;
    }

    public Type getActual() {
        return this.actual;
    }

    public String legacyMessage() {
        return this.oldMessage;
    }

    public Status status() {
        return Status.Request.Invalid;
    }

    public ErrorGqlStatusObject gqlStatusObject() {
        return this.gqlStatusObject;
    }
}

