/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.decoder.util;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.impl.util.BaseToObjectValueWriter;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class AuthenticationMetadataUtils {
    private AuthenticationMetadataUtils() {
    }

    public static Map<String, Object> extractAuthToken(List<String> ignoredFields, Map<String, Object> input) {
        return input.entrySet().stream().filter(e -> !ignoredFields.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, Object> convertExtraMap(PackstreamValueReader<Connection> reader, int limit) throws PackstreamReaderException {
        MapValue metadataMapValue;
        try {
            metadataMapValue = reader.readPrimitiveMap(limit);
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("extra", ex);
        }
        AuthTokenValueWriter writer = new AuthTokenValueWriter();
        HashMap<String, Object> metadataMap = new HashMap<String, Object>(metadataMapValue.size());
        metadataMapValue.foreach((key, value) -> {
            if (!AuthToken.containsSensitiveInformation((String)key)) {
                value.writeTo((AnyValueWriter)writer);
                metadataMap.put((String)key, writer.value());
            } else {
                metadataMap.put((String)key, AuthenticationMetadataUtils.sensitiveValueAsObject(value));
            }
        });
        return metadataMap;
    }

    private static Object sensitiveValueAsObject(AnyValue value) {
        if (value instanceof UTF8StringValue) {
            UTF8StringValue stringValue = (UTF8StringValue)value;
            return stringValue.bytes();
        }
        if (value instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            if (stringValue.isEmpty()) {
                return ArrayUtils.EMPTY_BYTE_ARRAY;
            }
            return stringValue.stringValue().getBytes(StandardCharsets.UTF_8);
        }
        if (value == Values.NO_VALUE) {
            return null;
        }
        return ((Value)value).asObjectCopy();
    }

    private static class AuthTokenValueWriter
    extends BaseToObjectValueWriter<RuntimeException> {
        private AuthTokenValueWriter() {
        }

        protected Node newNodeEntityById(long id) {
            throw new UnsupportedOperationException("Authentication tokens should not contain nodes");
        }

        protected Node newNodeEntityByElementId(String elementId) {
            throw new UnsupportedOperationException("Authentication tokens should not contain nodes");
        }

        protected Relationship newRelationshipEntityById(long id) {
            throw new UnsupportedOperationException("Authentication tokens should not contain relationships");
        }

        protected Relationship newRelationshipEntityByElementId(String elementId) {
            throw new UnsupportedOperationException("Authentication tokens should not contain relationships");
        }

        protected Point newPoint(CoordinateReferenceSystem crs, double[] coordinate) {
            throw new UnsupportedOperationException("Authentication tokens should not contain relationships");
        }
    }
}

