/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.negotiation.codec.ProtocolNegotiationRequestDecoder;
import org.neo4j.bolt.negotiation.codec.ProtocolNegotiationResponseEncoder;
import org.neo4j.bolt.negotiation.message.ProtocolNegotiationRequest;
import org.neo4j.bolt.negotiation.message.ProtocolNegotiationResponse;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.codec.BoltStructEncoder;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.netty.AbstractNettyConnector;
import org.neo4j.bolt.protocol.common.handler.HouseKeeperHandler;
import org.neo4j.bolt.protocol.common.handler.ProtocolLoggingHandler;
import org.neo4j.bolt.protocol.common.handler.RequestHandler;
import org.neo4j.bolt.protocol.common.handler.StateSignalFilterHandler;
import org.neo4j.bolt.protocol.common.handler.messages.GoodbyeMessageHandler;
import org.neo4j.bolt.protocol.common.message.response.ResponseMessage;
import org.neo4j.bolt.runtime.throttle.ChannelReadThrottleHandler;
import org.neo4j.bolt.runtime.throttle.ChannelWriteThrottleHandler;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.packstream.codec.PackstreamStructDecoder;
import org.neo4j.packstream.codec.PackstreamStructEncoder;
import org.neo4j.packstream.codec.transport.ChunkFrameDecoder;
import org.neo4j.packstream.codec.transport.ChunkFrameEncoder;
import org.neo4j.packstream.codec.transport.FrameSignalEncoder;

public class ProtocolHandshakeHandler
extends SimpleChannelInboundHandler<ProtocolNegotiationRequest> {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ProtocolHandshakeHandler.class);
    public static final int BOLT_MAGIC_PREAMBLE = 1616949271;
    private final InternalLogProvider logging;
    private final InternalLog log;
    private AbstractNettyConnector<?> connector;
    private Connection connection;

    public ProtocolHandshakeHandler(InternalLogProvider logging) {
        this.logging = logging;
        this.log = logging.getLog(((Object)((Object)this)).getClass());
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.connection = Connection.getConnection(ctx.channel());
        this.connector = (AbstractNettyConnector)this.connection.connector();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.connection.memoryTracker().releaseHeap(SHALLOW_SIZE);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ProtocolNegotiationRequest request) throws Exception {
        ChunkFrameDecoder frameDecoder;
        long readLimit;
        if (request.getMagicNumber() != 1616949271) {
            this.log.debug("Invalid Bolt handshake signature. Expected 0x%08X, but got: 0x%08X", new Object[]{1616949271, request.getMagicNumber()});
            ctx.close();
            return;
        }
        BoltProtocol selectedProtocol = null;
        BoltProtocolRegistry protocolRegistry = this.connector.protocolRegistry();
        Iterator<ProtocolVersion> it = request.proposedVersions().iterator();
        do {
            if (!it.hasNext()) {
                this.log.debug("Failed Bolt handshake: Bolt versions suggested by client '%s' are not supported by this server.", new Object[]{Arrays.toString(request.proposedVersions().toArray())});
                ctx.writeAndFlush((Object)new ProtocolNegotiationResponse(ProtocolVersion.INVALID)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            ProtocolVersion proposal = it.next();
            if (ProtocolVersion.INVALID.equals(proposal)) continue;
            selectedProtocol = protocolRegistry.get(proposal).orElse(null);
        } while (selectedProtocol == null);
        BoltProtocol protocol = selectedProtocol;
        this.connection.selectProtocol(protocol);
        ctx.writeAndFlush((Object)new ProtocolNegotiationResponse(protocol.version()));
        ctx.pipeline().addLast(new ChannelHandler[]{new StateSignalFilterHandler()}).addLast(new ChannelHandler[]{new FrameSignalEncoder(protocol.frameSignalFilter())});
        AbstractNettyConnector.NettyConfiguration config = (AbstractNettyConnector.NettyConfiguration)this.connector.configuration();
        if (config.enableOutboundBufferThrottle()) {
            ctx.channel().config().setWriteBufferWaterMark(new WriteBufferWaterMark(config.outboundBufferThrottleLowWatermark(), config.outboundBufferThrottleHighWatermark()));
        }
        if ((readLimit = config.maxAuthenticationInboundBytes()) != 0L) {
            this.log.debug("Imposing %d byte read-limit on connection '%s' until authentication is completed", new Object[]{readLimit, this.connection.id()});
            frameDecoder = new ChunkFrameDecoder(readLimit, this.logging);
        } else {
            frameDecoder = new ChunkFrameDecoder(this.logging);
        }
        if (config.enableMergeCumulator()) {
            this.log.warn("Enabling merge cumulator for chunk decoding - Network performance may be degraded");
            frameDecoder.setCumulator(ByteToMessageDecoder.MERGE_CUMULATOR);
        }
        ctx.pipeline().addLast("chunkFrameDecoder", (ChannelHandler)frameDecoder);
        if (config.enableProtocolLogging() && config.protocolLoggingMode().isLoggingRawTraffic()) {
            ctx.pipeline().remove("rawProtocolLoggingHandler");
            ctx.pipeline().addLast("rawProtocolLoggingHandler", (ChannelHandler)new ProtocolLoggingHandler(this.logging));
        }
        ctx.pipeline().addLast("chunkFrameEncoder", (ChannelHandler)new ChunkFrameEncoder()).addLast("structDecoder", new PackstreamStructDecoder<Connection>(this.connection, protocol.requestMessageRegistry(), this.logging)).addLast("structEncoder", new PackstreamStructEncoder<Connection, ResponseMessage>(ResponseMessage.class, this.connection, protocol.responseMessageRegistry()));
        int inboundMessageThrottleHighWatermark = config.inboundBufferThrottleHighWatermark();
        if (inboundMessageThrottleHighWatermark != 0) {
            ctx.pipeline().addLast("readThrottleHandler", (ChannelHandler)new ChannelReadThrottleHandler(config.inboundBufferThrottleLowWatermark(), inboundMessageThrottleHighWatermark, this.logging));
        }
        if (config.enableProtocolLogging() && config.protocolLoggingMode().isLoggingDecodedTraffic()) {
            ctx.pipeline().remove("decodedProtocolLoggingHandler");
            ctx.pipeline().addLast("decodedProtocolLoggingHandler", (ChannelHandler)new ProtocolLoggingHandler(this.logging));
        }
        ctx.pipeline().addLast("goodbyeMessageHandler", (ChannelHandler)new GoodbyeMessageHandler(this.logging)).addLast("boltStructEncoder", (ChannelHandler)new BoltStructEncoder());
        boolean writeThrottleEnabled = config.enableOutboundBufferThrottle();
        long writeTimeoutMillis = config.outboundBufferMaxThrottleDuration().toMillis();
        if (writeThrottleEnabled && writeTimeoutMillis != 0L) {
            ctx.pipeline().addLast("channelThrottleHandler", (ChannelHandler)new ChannelWriteThrottleHandler(writeTimeoutMillis, this.logging));
        }
        ctx.pipeline().addLast("requestHandler", (ChannelHandler)new RequestHandler(this.logging)).addLast("housekeeper", (ChannelHandler)new HouseKeeperHandler(this.logging)).remove((ChannelHandler)this);
        ctx.pipeline().remove(ProtocolNegotiationResponseEncoder.class);
        ctx.pipeline().remove(ProtocolNegotiationRequestDecoder.class);
        this.connection.notifyListeners(listener -> listener.onProtocolSelected(protocol));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.log.error("Fatal error occurred during protocol handshaking: " + ctx.channel(), cause);
        ctx.close();
    }
}

