/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v43.fsm;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.routing.RoutingTableGetter;
import org.neo4j.bolt.protocol.v43.message.request.RouteMessage;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;

public class ReadyState
extends org.neo4j.bolt.protocol.v40.fsm.ReadyState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ReadyState.class);
    private static final String ROUTING_TABLE_KEY = "rt";
    private final RoutingTableGetter routingTableGetter;

    public ReadyState(RoutingTableGetter routingTableGetter) {
        this.routingTableGetter = routingTableGetter;
    }

    @Override
    public State processUnsafe(RequestMessage message, StateMachineContext context) throws Exception {
        if (message instanceof RouteMessage) {
            RouteMessage routeMessage = (RouteMessage)message;
            return this.processRouteMessage(routeMessage, context);
        }
        return super.processUnsafe(message, context);
    }

    protected State processRouteMessage(RouteMessage message, StateMachineContext context) throws Exception {
        String programId = UUID.randomUUID().toString();
        context.connectionState().setCurrentTransactionId(programId);
        try {
            ((CompletableFuture)this.routingTableGetter.get(programId, context.connection().loginContext(), context.transactionManager(), message.getRequestContext(), message.getBookmarks(), message.getDatabaseName(), context.connectionId()).thenAccept(routingTable -> this.onRoutingTableReceived(context, message, (MapValue)routingTable))).join();
        }
        catch (CompletionException ex) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                context.handleFailure(cause, false);
                return this.failedState;
            }
            throw ex;
        }
        return this;
    }

    protected void onRoutingTableReceived(StateMachineContext context, RouteMessage message, MapValue routingTable) {
        context.connectionState().onMetadata(ROUTING_TABLE_KEY, (AnyValue)routingTable);
    }
}

