/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.messaging.decoder;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.v40.messaging.request.HelloMessage;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.impl.util.BaseToObjectValueWriter;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class HelloMessageDecoder
implements StructReader<Connection, HelloMessage> {
    private static final HelloMessageDecoder INSTANCE = new HelloMessageDecoder();

    protected HelloMessageDecoder() {
    }

    public static HelloMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 1;
    }

    @Override
    public HelloMessage read(Connection ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        if (header.length() != 1L) {
            throw new IllegalStructSizeException(1L, header.length());
        }
        PackstreamValueReader<Connection> reader = ctx.valueReader(buffer);
        Map<String, Object> meta = this.readMetaDataMap(reader, buffer.getTarget().readableBytes());
        Object userAgent = meta.get("user_agent");
        if (userAgent == null) {
            throw new IllegalStructArgumentException("user_agent", "Expected \"user_agent\" to be non-null");
        }
        if (!(userAgent instanceof String)) {
            throw new IllegalStructArgumentException("user_agent", "Expected value to be a string");
        }
        return new HelloMessage(meta);
    }

    protected Map<String, Object> readMetaDataMap(PackstreamValueReader<Connection> reader, int limit) throws PackstreamReaderException {
        MapValue metaDataMapValue;
        try {
            metaDataMapValue = reader.readPrimitiveMap(limit);
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("extra", ex);
        }
        AuthTokenValueWriter writer = new AuthTokenValueWriter();
        HashMap<String, Object> metaDataMap = new HashMap<String, Object>(metaDataMapValue.size());
        metaDataMapValue.foreach((key, value) -> {
            if (!AuthToken.containsSensitiveInformation((String)key)) {
                value.writeTo((AnyValueWriter)writer);
                metaDataMap.put((String)key, writer.value());
            } else {
                metaDataMap.put((String)key, HelloMessageDecoder.sensitiveValueAsObject(value));
            }
        });
        return metaDataMap;
    }

    protected static Object sensitiveValueAsObject(AnyValue value) {
        if (value instanceof UTF8StringValue) {
            UTF8StringValue stringValue = (UTF8StringValue)value;
            return stringValue.bytes();
        }
        if (value instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            if (stringValue.isEmpty()) {
                return ArrayUtils.EMPTY_BYTE_ARRAY;
            }
            return stringValue.stringValue().getBytes(StandardCharsets.UTF_8);
        }
        if (value == Values.NO_VALUE) {
            return null;
        }
        return ((Value)value).asObjectCopy();
    }

    private static class AuthTokenValueWriter
    extends BaseToObjectValueWriter<RuntimeException> {
        private AuthTokenValueWriter() {
        }

        protected Node newNodeEntityById(long id) {
            throw new UnsupportedOperationException("Authentication tokens should not contain nodes");
        }

        protected Node newNodeEntityByElementId(String elementId) {
            throw new UnsupportedOperationException("Authentication tokens should not contain nodes");
        }

        protected Relationship newRelationshipEntityById(long id) {
            throw new UnsupportedOperationException("Authentication tokens should not contain relationships");
        }

        protected Relationship newRelationshipEntityByElementId(String elementId) {
            throw new UnsupportedOperationException("Authentication tokens should not contain relationships");
        }

        protected Point newPoint(CoordinateReferenceSystem crs, double[] coordinate) {
            throw new UnsupportedOperationException("Authentication tokens should not contain relationships");
        }

        Object valueAsObject(AnyValue value) {
            value.writeTo((AnyValueWriter)this);
            return this.value();
        }
    }
}

