/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.fsm;

import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.result.ResultConsumer;
import org.neo4j.bolt.protocol.common.signal.StateSignal;
import org.neo4j.bolt.protocol.v40.fsm.FailSafeState;
import org.neo4j.bolt.protocol.v40.messaging.request.DiscardMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.PullMessage;
import org.neo4j.bolt.protocol.v40.messaging.result.DiscardResultConsumer;
import org.neo4j.bolt.protocol.v40.messaging.result.PullResultConsumer;
import org.neo4j.util.Preconditions;

public abstract class AbstractStreamingState
extends FailSafeState {
    protected State readyState;

    @Override
    protected State processUnsafe(RequestMessage message, StateMachineContext context) throws Throwable {
        context.connectionState().ensureNoPendingTerminationNotice();
        State nextState = null;
        if (message instanceof PullMessage) {
            PullMessage pullMessage = (PullMessage)message;
            nextState = this.processStreamPullResultMessage(pullMessage.statementId(), new PullResultConsumer(context, pullMessage.n()), context, pullMessage.n());
        } else if (message instanceof DiscardMessage) {
            DiscardMessage discardMessage = (DiscardMessage)message;
            nextState = this.processStreamDiscardResultMessage(discardMessage.statementId(), new DiscardResultConsumer(context, discardMessage.n()), context, discardMessage.n());
        }
        if (nextState != this) {
            context.connection().write((Object)StateSignal.EXIT_STREAMING);
        }
        return nextState;
    }

    public void setReadyState(State readyState) {
        this.readyState = readyState;
    }

    protected abstract State processStreamPullResultMessage(int var1, ResultConsumer var2, StateMachineContext var3, long var4) throws Throwable;

    protected abstract State processStreamDiscardResultMessage(int var1, ResultConsumer var2, StateMachineContext var3, long var4) throws Throwable;

    @Override
    protected void assertInitialized() {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
        super.assertInitialized();
    }
}

