/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.bookmark;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.neo4j.bolt.dbapi.CustomBookmarkFormatParser;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.bookmark.BookmarkParser;
import org.neo4j.bolt.protocol.error.bookmark.BookmarkFormatException;
import org.neo4j.bolt.protocol.error.bookmark.BookmarkParserException;
import org.neo4j.bolt.protocol.error.bookmark.InvalidBookmarkMixtureException;
import org.neo4j.bolt.protocol.error.bookmark.MalformedBookmarkException;
import org.neo4j.bolt.protocol.error.bookmark.UnknownDatabaseBookmarkException;
import org.neo4j.bolt.protocol.v40.bookmark.BookmarkWithDatabaseId;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;

public final class BookmarkParserV40
implements BookmarkParser {
    private static final long ABSENT_BOOKMARK_ID = -1L;
    private final DatabaseIdRepository databaseIdRepository;
    private final CustomBookmarkFormatParser customBookmarkFormatParser;

    public BookmarkParserV40(DatabaseIdRepository databaseIdRepository, CustomBookmarkFormatParser customBookmarkFormatParser) {
        this.databaseIdRepository = databaseIdRepository;
        this.customBookmarkFormatParser = customBookmarkFormatParser;
    }

    @Override
    public List<Bookmark> parseBookmarks(ListValue bookmarks) throws BookmarkParserException {
        List<Bookmark> customBookmarks;
        long maxSystemDbTxId = -1L;
        NamedDatabaseId userDbId = null;
        long maxUserDbTxId = -1L;
        ArrayList<String> customBookmarkStrings = new ArrayList<String>();
        for (AnyValue bookmark : bookmarks) {
            if (bookmark == Values.NO_VALUE) continue;
            String bookmarkString = BookmarkParserV40.toBookmarkString(bookmark);
            if (this.customBookmarkFormatParser.isCustomBookmark(bookmarkString)) {
                customBookmarkStrings.add(bookmarkString);
                continue;
            }
            BookmarkWithDatabaseId parsedBookmark = this.parse(bookmarkString);
            if (NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID.equals((Object)parsedBookmark.namedDatabaseId())) {
                maxSystemDbTxId = Math.max(maxSystemDbTxId, parsedBookmark.txId());
                continue;
            }
            if (userDbId == null) {
                userDbId = parsedBookmark.namedDatabaseId();
            } else if (!userDbId.equals((Object)parsedBookmark.namedDatabaseId())) {
                throw new InvalidBookmarkMixtureException(bookmarks);
            }
            maxUserDbTxId = Math.max(maxUserDbTxId, parsedBookmark.txId());
        }
        if (customBookmarkStrings.isEmpty()) {
            return BookmarkParserV40.buildBookmarks(maxSystemDbTxId, userDbId, maxUserDbTxId);
        }
        try {
            customBookmarks = this.customBookmarkFormatParser.parse(customBookmarkStrings);
        }
        catch (Exception e) {
            throw new MalformedBookmarkException("Parsing of supplied bookmarks failed with message: " + e.getMessage(), e);
        }
        if (maxSystemDbTxId != -1L) {
            customBookmarks.add(new BookmarkWithDatabaseId(maxSystemDbTxId, NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID));
        }
        if (maxUserDbTxId != -1L) {
            customBookmarks.add(new BookmarkWithDatabaseId(maxUserDbTxId, userDbId));
        }
        return customBookmarks;
    }

    private BookmarkWithDatabaseId parse(String bookmarkString) throws BookmarkParserException {
        String[] split = bookmarkString.split(":");
        if (split.length != 2) {
            throw new BookmarkFormatException((Object)bookmarkString);
        }
        UUID databaseUuid = BookmarkParserV40.parseDatabaseId(split[0], bookmarkString);
        long txId = BookmarkParserV40.parseTxId(split[1], bookmarkString);
        NamedDatabaseId databaseId = (NamedDatabaseId)this.databaseIdRepository.getById(DatabaseIdFactory.from((UUID)databaseUuid)).orElseThrow(() -> new UnknownDatabaseBookmarkException(databaseUuid));
        return new BookmarkWithDatabaseId(txId, databaseId);
    }

    private static String toBookmarkString(AnyValue bookmark) throws BookmarkParserException {
        if (bookmark instanceof TextValue) {
            TextValue bookmarkString = (TextValue)bookmark;
            return bookmarkString.stringValue();
        }
        throw new BookmarkFormatException(bookmark);
    }

    private static UUID parseDatabaseId(String uuid, String bookmark) throws BookmarkParserException {
        try {
            return UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            throw new BookmarkFormatException(bookmark, String.format("Unable to parse database id: %s", uuid), e);
        }
    }

    private static long parseTxId(String txIdString, String bookmark) throws BookmarkParserException {
        try {
            return Long.parseLong(txIdString);
        }
        catch (NumberFormatException e) {
            throw new BookmarkFormatException(bookmark, String.format("Unable to parse transaction id: %s", txIdString), e);
        }
    }

    private static List<Bookmark> buildBookmarks(long maxSystemDbTxId, NamedDatabaseId userDbId, long maxUserDbTxId) {
        if (maxSystemDbTxId != -1L && maxUserDbTxId != -1L) {
            return List.of(new BookmarkWithDatabaseId(maxSystemDbTxId, NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID), new BookmarkWithDatabaseId(maxUserDbTxId, userDbId));
        }
        if (maxSystemDbTxId != -1L) {
            return List.of(new BookmarkWithDatabaseId(maxSystemDbTxId, NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID));
        }
        if (maxUserDbTxId != -1L) {
            return List.of(new BookmarkWithDatabaseId(maxUserDbTxId, userDbId));
        }
        return List.of();
    }
}

