/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.transaction.statement;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.result.ResultConsumer;
import org.neo4j.bolt.protocol.common.transaction.statement.metadata.StatementMetadata;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.virtual.MapValue;

public interface StatementProcessor {
    public static final StatementProcessor EMPTY = new StatementProcessor(){

        @Override
        public void beginTransaction(List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, String txType) {
            throw new UnsupportedOperationException("Unable to begin a transaction");
        }

        @Override
        public StatementMetadata run(String statement, MapValue params) {
            throw new UnsupportedOperationException("Unable to run statements");
        }

        @Override
        public StatementMetadata run(String statement, MapValue params, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetaData) {
            throw new UnsupportedOperationException("Unable to run statements");
        }

        @Override
        public Bookmark streamResult(int statementId, ResultConsumer resultConsumer) {
            throw new UnsupportedOperationException("Unable to stream results");
        }

        @Override
        public Bookmark commitTransaction() {
            throw new UnsupportedOperationException("Unable to commit a transaction");
        }

        @Override
        public void rollbackTransaction() {
            throw new UnsupportedOperationException("Unable to rollback a transaction");
        }

        @Override
        public void reset() {
        }

        @Override
        public void markCurrentTransactionForTermination() {
        }

        @Override
        public boolean hasTransaction() {
            return false;
        }

        @Override
        public boolean hasOpenStatement() {
            return false;
        }

        @Override
        public Status validateTransaction() {
            return null;
        }

        @Override
        public String databaseName() {
            throw new UnsupportedOperationException("Unable to read the database ID");
        }

        public String toString() {
            return "Empty Statement Processor";
        }
    };

    public void beginTransaction(List<Bookmark> var1, Duration var2, AccessMode var3, Map<String, Object> var4, String var5) throws KernelException;

    public StatementMetadata run(String var1, MapValue var2) throws KernelException;

    public StatementMetadata run(String var1, MapValue var2, List<Bookmark> var3, Duration var4, AccessMode var5, Map<String, Object> var6) throws KernelException;

    public Bookmark streamResult(int var1, ResultConsumer var2) throws Throwable;

    public Bookmark commitTransaction() throws KernelException;

    public void rollbackTransaction() throws KernelException;

    public void reset() throws TransactionFailureException;

    public void markCurrentTransactionForTermination();

    public boolean hasTransaction();

    public boolean hasOpenStatement();

    public Status validateTransaction() throws KernelException;

    public String databaseName();
}

