/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.memory.HeapEstimator;

public class AuthenticationTimeoutHandler
extends IdleStateHandler {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(AuthenticationTimeoutHandler.class);
    private final Duration timeout;
    private Connection connection;
    private volatile boolean requestReceived;

    public AuthenticationTimeoutHandler(Duration timeout) {
        super(timeout.toMillis(), 0L, 0L, TimeUnit.MILLISECONDS);
        this.timeout = timeout;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.connection = Connection.getConnection(ctx.channel());
        super.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.connection.memoryTracker().releaseHeap(SHALLOW_SIZE);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ctx.fireChannelRead(msg);
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        ctx.close();
        if (this.requestReceived) {
            throw new BoltConnectionFatality(String.format("Terminated connection '%s' (%s) as the server failed to handle an authentication request within %d ms.", this.connection.id(), ctx.channel(), this.timeout.toMillis()), null);
        }
        throw new BoltConnectionFatality(String.format("Terminated connection '%s' (%s) as the client failed to authenticate within %d ms.", this.connection.id(), ctx.channel(), this.timeout.toMillis()), null);
    }

    public void setRequestReceived(boolean requestReceived) {
        this.requestReceived = requestReceived;
    }
}

