/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.io;

import io.netty.buffer.ByteBuf;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum LengthPrefix {
    NONE(0, 0L),
    NIBBLE(0, 15L),
    UINT8(1, 255L){

        @Override
        public long readFrom(ByteBuf source) {
            return source.readUnsignedByte();
        }

        @Override
        public void writeTo(ByteBuf target, long length) {
            target.writeByte((int)length);
        }
    }
    ,
    UINT16(2, 65535L){

        @Override
        public long readFrom(ByteBuf source) {
            return source.readUnsignedShort();
        }

        @Override
        public void writeTo(ByteBuf target, long length) {
            target.writeShort((int)length);
        }
    }
    ,
    UINT32(4, 0xFFFFFFFFL){

        @Override
        public long readFrom(ByteBuf source) {
            return source.readUnsignedInt();
        }

        @Override
        public void writeTo(ByteBuf target, long length) {
            target.writeInt((int)length);
        }
    };

    private final int encodedLength;
    private final long maxValue;

    private LengthPrefix(int encodedLength, long maxValue) {
        this.encodedLength = encodedLength;
        this.maxValue = maxValue;
    }

    public int getEncodedLength() {
        return this.encodedLength;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public boolean canEncode(long length) {
        return length <= this.maxValue;
    }

    public long readFrom(ByteBuf source) {
        throw new UnsupportedOperationException();
    }

    public void writeTo(ByteBuf target, long length) {
        throw new UnsupportedOperationException();
    }
}

