/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.netty;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import java.net.SocketAddress;
import java.time.Clock;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.connection.BoltDriverMetricsMonitor;
import org.neo4j.bolt.protocol.common.connection.hint.ConnectionHintRegistry;
import org.neo4j.bolt.protocol.common.connector.accounting.error.ErrorAccountant;
import org.neo4j.bolt.protocol.common.connector.accounting.traffic.NoopTrafficAccountant;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.netty.AbstractNettyConnector;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorTransport;
import org.neo4j.bolt.protocol.common.handler.BoltChannelInitializer;
import org.neo4j.bolt.security.Authentication;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.server.config.AuthConfigProvider;

public class LocalNettyConnector
extends AbstractNettyConnector {
    private final ConnectorTransport transport;
    private final EventLoopGroup workerGroup;
    private final ByteBufAllocator byteBufAllocator;
    private final Config config;
    private final InternalLogProvider internalLogProvider;

    public LocalNettyConnector(String id, SocketAddress bindAddress, MemoryPool memoryPool, Clock clock, Connection.Factory connectionFactory, NetworkConnectionTracker connectionTracker, BoltProtocolRegistry protocolRegistry, Authentication authentication, AuthConfigProvider authConfigProvider, DefaultDatabaseResolver defaultDatabaseResolver, ConnectionHintRegistry connectionHintRegistry, TransactionManager transactionManager, RoutingService routingService, ErrorAccountant errorAccountant, BoltDriverMetricsMonitor driverMetricsMonitor, int streamingBufferSize, int streamingFlushThreshold, InternalLogProvider userLogProvider, InternalLogProvider internalLogProvider, ConnectorTransport connectorTransport, EventLoopGroup workerGroup, Config config, ByteBufAllocator byteBufAllocator) {
        super(id, bindAddress, memoryPool, clock, connectionFactory, connectionTracker, false, protocolRegistry, authentication, authConfigProvider, defaultDatabaseResolver, connectionHintRegistry, transactionManager, routingService, errorAccountant, NoopTrafficAccountant.getInstance(), driverMetricsMonitor, streamingBufferSize, streamingFlushThreshold, userLogProvider, internalLogProvider);
        this.transport = connectorTransport;
        this.workerGroup = workerGroup;
        this.byteBufAllocator = byteBufAllocator;
        this.config = config;
        this.internalLogProvider = internalLogProvider;
    }

    @Override
    protected EventLoopGroup workerGroup() {
        return this.workerGroup;
    }

    @Override
    protected Class<? extends ServerChannel> channelType() {
        return this.transport.getLocalChannelType();
    }

    @Override
    protected ChannelInitializer<Channel> channelInitializer() {
        return new BoltChannelInitializer(this.config, this, this.byteBufAllocator, this.internalLogProvider);
    }
}

