/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.transition.negotiation;

import java.util.List;
import java.util.Map;
import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.fsm.state.transition.AbstractStateTransition;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.common.fsm.States;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.notifications.NotificationsConfig;
import org.neo4j.bolt.protocol.common.message.request.authentication.HelloMessage;
import org.neo4j.bolt.protocol.common.message.request.connection.RoutingContext;
import org.neo4j.kernel.internal.Version;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValueBuilder;

public final class HelloStateTransition
extends AbstractStateTransition<HelloMessage> {
    private static final HelloStateTransition INSTANCE = new HelloStateTransition();

    private HelloStateTransition() {
        super(HelloMessage.class);
    }

    public static HelloStateTransition getInstance() {
        return INSTANCE;
    }

    @Override
    public StateReference process(Context ctx, HelloMessage message, ResponseHandler handler) throws StateMachineException {
        List<Feature> features = message.features();
        String userAgent = message.userAgent();
        RoutingContext routingContext = message.routingContext();
        NotificationsConfig notificationsConfig = message.notificationsConfig();
        Map<String, String> boltAgent = message.boltAgent();
        List<Feature> enabledFeatures = ctx.connection().negotiate(features, userAgent, routingContext, notificationsConfig, boltAgent);
        if (!enabledFeatures.isEmpty()) {
            ListValueBuilder builder = ListValueBuilder.newListBuilder((int)enabledFeatures.size());
            enabledFeatures.forEach(feature -> builder.add((AnyValue)Values.stringValue((String)feature.getId())));
            handler.onMetadata("patch_bolt", (AnyValue)builder.build());
        }
        handler.onMetadata("connection_id", (AnyValue)Values.stringValue((String)ctx.connection().id()));
        handler.onMetadata("server", (AnyValue)Values.stringValue((String)("Neo4j/" + Version.getNeo4jVersion())));
        MapValueBuilder connectionHints = new MapValueBuilder();
        ctx.connection().connector().connectionHintProvider().append(connectionHints);
        handler.onMetadata("hints", (AnyValue)connectionHints.build());
        ctx.defaultState(States.AUTHENTICATION);
        return States.AUTHENTICATION;
    }
}

