/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector;

import io.netty.channel.Channel;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.connection.BoltDriverMetricsMonitor;
import org.neo4j.bolt.protocol.common.connection.ConnectionHintProvider;
import org.neo4j.bolt.protocol.common.connector.ConnectionRegistry;
import org.neo4j.bolt.protocol.common.connector.Connector;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.listener.ConnectorListener;
import org.neo4j.bolt.security.Authentication;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.server.config.AuthConfigProvider;

public abstract class AbstractConnector
implements Connector {
    private final String id;
    private final MemoryPool memoryPool;
    private final Clock clock;
    private final Connection.Factory connectionFactory;
    private final boolean encryptionRequired;
    private final BoltProtocolRegistry protocolRegistry;
    private final Authentication authentication;
    private final AuthConfigProvider authConfigProvider;
    private final DefaultDatabaseResolver defaultDatabaseResolver;
    private final ConnectionHintProvider connectionHintProvider;
    private final TransactionManager transactionManager;
    private final RoutingService routingService;
    private final ConnectionRegistry connectionRegistry;
    private final BoltDriverMetricsMonitor driverMetricsMonitor;
    private final int streamingBufferSize;
    private final int streamingFlushThreshold;
    private final List<ConnectorListener> listeners = new ArrayList<ConnectorListener>();

    public AbstractConnector(String id, MemoryPool memoryPool, Clock clock, Connection.Factory connectionFactory, NetworkConnectionTracker connectionTracker, boolean encryptionRequired, BoltProtocolRegistry protocolRegistry, Authentication authentication, AuthConfigProvider authConfigProvider, DefaultDatabaseResolver defaultDatabaseResolver, ConnectionHintProvider connectionHintProvider, TransactionManager transactionManager, int streamingBufferSize, int streamingFlushThreshold, RoutingService routingService, BoltDriverMetricsMonitor driverMetricsMonitor, InternalLogProvider logging) {
        this.id = id;
        this.clock = clock;
        this.memoryPool = memoryPool;
        this.connectionFactory = connectionFactory;
        this.encryptionRequired = encryptionRequired;
        this.protocolRegistry = protocolRegistry;
        this.authentication = authentication;
        this.authConfigProvider = authConfigProvider;
        this.defaultDatabaseResolver = defaultDatabaseResolver;
        this.connectionHintProvider = connectionHintProvider;
        this.transactionManager = transactionManager;
        this.routingService = routingService;
        this.streamingBufferSize = streamingBufferSize;
        this.streamingFlushThreshold = streamingFlushThreshold;
        this.driverMetricsMonitor = driverMetricsMonitor;
        this.connectionRegistry = new ConnectionRegistry(id, connectionTracker, logging);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public MemoryPool memoryPool() {
        return this.memoryPool;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public ConnectionRegistry connectionRegistry() {
        return this.connectionRegistry;
    }

    @Override
    public boolean isEncryptionRequired() {
        return this.encryptionRequired;
    }

    @Override
    public BoltProtocolRegistry protocolRegistry() {
        return this.protocolRegistry;
    }

    @Override
    public Authentication authentication() {
        return this.authentication;
    }

    @Override
    public AuthConfigProvider authConfigProvider() {
        return this.authConfigProvider;
    }

    @Override
    public DefaultDatabaseResolver defaultDatabaseResolver() {
        return this.defaultDatabaseResolver;
    }

    @Override
    public ConnectionHintProvider connectionHintProvider() {
        return this.connectionHintProvider;
    }

    @Override
    public TransactionManager transactionManager() {
        return this.transactionManager;
    }

    @Override
    public RoutingService routingService() {
        return this.routingService;
    }

    @Override
    public BoltDriverMetricsMonitor driverMetricsMonitor() {
        return this.driverMetricsMonitor;
    }

    @Override
    public int streamingBufferSize() {
        return this.streamingBufferSize;
    }

    @Override
    public int streamingFlushThreshold() {
        return this.streamingFlushThreshold;
    }

    @Override
    public void registerListener(ConnectorListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
        listener.onListenerAdded();
    }

    @Override
    public void removeListener(ConnectorListener listener) {
        this.listeners.remove(listener);
        listener.onListenerRemoved();
    }

    @Override
    public void notifyListeners(Consumer<ConnectorListener> notifierFunction) {
        this.listeners.forEach(notifierFunction);
    }

    @Override
    public Connection createConnection(Channel channel) {
        String connectionId = this.connectionRegistry.allocateId();
        Connection connection = this.connectionFactory.create(this, connectionId, channel);
        Connection.setAttribute(channel, connection);
        this.connectionRegistry.register(connection);
        channel.closeFuture().addListener(future -> {
            try {
                connection.close();
            }
            finally {
                this.connectionRegistry.unregister(connection);
            }
        });
        this.notifyListeners(listener -> listener.onConnectionCreated(connection));
        return connection;
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.connectionRegistry.stopIdling();
    }

    @Override
    public void shutdown() throws Exception {
        this.connectionRegistry.stopAll();
    }
}

