/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.txtracking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.bolt.txtracking.ReconciledTransactionTracker;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.util.Preconditions;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public class DefaultReconciledTransactionTracker
implements ReconciledTransactionTracker {
    private static final int INITIAL_ARRAY_SIZE = 200;
    private static final long[] NO_METADATA = ArrayUtils.EMPTY_LONG_ARRAY;
    private final ReadWriteLock initializationLock;
    private final InternalLog log;
    private long startingNumber;
    private OutOfOrderSequence sequence;
    private final Collection<Long> outstanding = new ArrayList<Long>();
    private long fixedId = -1L;

    public DefaultReconciledTransactionTracker(LogService logService) {
        this.initializationLock = new ReentrantReadWriteLock();
        this.log = logService.getInternalLog(this.getClass());
    }

    @Override
    public void disable() {
        this.initializationLock.writeLock().lock();
        try {
            if (this.sequence == null) {
                return;
            }
            this.fixedId = this.sequence.getHighestGapFreeNumber();
            this.sequence = null;
        }
        finally {
            this.initializationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enable(long reconciledTransactionId) {
        Preconditions.requireNonNegative((long)reconciledTransactionId);
        this.initializationLock.writeLock().lock();
        try {
            if (this.sequence == null) {
                this.log.info("Enabling with transaction ID %s", new Object[]{reconciledTransactionId});
            } else {
                this.log.warn("Enabling when not disabled with %s to transaction ID %s", new Object[]{this.sequence, reconciledTransactionId});
            }
            this.sequence = new ArrayQueueOutOfOrderSequence(reconciledTransactionId, 200, NO_METADATA);
            this.startingNumber = reconciledTransactionId;
            for (long txId : this.outstanding) {
                if (txId <= reconciledTransactionId) continue;
                this.sequence.offer(txId, NO_METADATA);
            }
            this.outstanding.clear();
        }
        finally {
            this.initializationLock.writeLock().unlock();
        }
    }

    @Override
    public long getLastReconciledTransactionId() {
        this.initializationLock.readLock().lock();
        try {
            long l = this.sequence != null ? this.sequence.getHighestGapFreeNumber() : this.fixedId;
            return l;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offerReconciledTransactionId(long reconciledTransactionId) {
        Preconditions.requireNonNegative((long)reconciledTransactionId);
        this.initializationLock.readLock().lock();
        try {
            if (this.sequence == null) {
                this.log.info("Outstanding ID %s", new Object[]{reconciledTransactionId});
                this.outstanding.add(reconciledTransactionId);
            } else if (reconciledTransactionId < this.startingNumber) {
                this.log.info("Ignoring pre-enabled ID %s", new Object[]{reconciledTransactionId});
            } else {
                long currentLastReconciledTxId = this.sequence.getHighestGapFreeNumber();
                Preconditions.checkArgument((reconciledTransactionId > currentLastReconciledTxId ? 1 : 0) != 0, (String)"Received illegal transaction ID %s which is lower than the current transaction ID %s. Sequence: %s", (Object[])new Object[]{reconciledTransactionId, currentLastReconciledTxId, this.sequence});
                this.log.debug("Updating %s with transaction ID %s", new Object[]{this.sequence, reconciledTransactionId});
                this.sequence.offer(reconciledTransactionId, NO_METADATA);
            }
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }
}

