/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.transition.ready;

import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.fsm.state.transition.AbstractStateTransition;
import org.neo4j.bolt.protocol.common.fsm.States;
import org.neo4j.bolt.protocol.common.fsm.error.AuthenticationStateTransitionException;
import org.neo4j.bolt.protocol.common.fsm.error.TransactionStateTransitionException;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.request.transaction.RunMessage;
import org.neo4j.bolt.protocol.common.signal.StateSignal;
import org.neo4j.bolt.security.error.AuthenticationException;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.bolt.tx.error.TransactionException;
import org.neo4j.bolt.tx.statement.Statement;

public final class CreateAutocommitStatementStateTransition
extends AbstractStateTransition<RunMessage> {
    private static final CreateAutocommitStatementStateTransition INSTANCE = new CreateAutocommitStatementStateTransition();

    private CreateAutocommitStatementStateTransition() {
        super(RunMessage.class);
    }

    public static CreateAutocommitStatementStateTransition getInstance() {
        return INSTANCE;
    }

    @Override
    public StateReference process(Context ctx, RunMessage message, ResponseHandler handler) throws StateMachineException {
        if (message.impersonatedUser() != null) {
            try {
                ctx.connection().impersonate(message.impersonatedUser());
            }
            catch (AuthenticationException ex) {
                throw new AuthenticationStateTransitionException(ex);
            }
        }
        long start = ctx.clock().millis();
        try {
            Transaction tx = ctx.connection().beginTransaction(TransactionType.IMPLICIT, message.databaseName(), message.getAccessMode(), message.bookmarks(), message.transactionTimeout(), message.transactionMetadata(), message.notificationsConfig());
            Statement statement = tx.run(message.statement(), message.params());
            long end = ctx.clock().millis();
            handler.onStatementPrepared(TransactionType.IMPLICIT, statement.id(), end - start, statement.fieldNames());
        }
        catch (TransactionException ex) {
            throw new TransactionStateTransitionException(ex);
        }
        ctx.write((Object)StateSignal.ENTER_STREAMING);
        return States.AUTO_COMMIT;
    }
}

