/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connection;

import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValueBuilder;

@FunctionalInterface
public interface ConnectionHintProvider {
    public static ConnectionHintProvider noop() {
        return hints -> {};
    }

    public static ConnectionHintProvider forKey(String key, Supplier<AnyValue> supplier) {
        return hints -> hints.add(key, (AnyValue)supplier.get());
    }

    public static <I> ConnectionHintProvider forConfig(String key, Config config, Setting<I> setting, Function<I, AnyValue> converter) {
        return ConnectionHintProvider.forKey(key, () -> (AnyValue)converter.apply(config.get(setting)));
    }

    public void append(MapValueBuilder var1);

    default public ConnectionHintProvider and(ConnectionHintProvider next) {
        ConnectionHintProvider curr = this;
        return hints -> {
            curr.append(hints);
            next.append(hints);
        };
    }
}

