/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol;

import org.neo4j.bolt.fsm.StateMachineConfiguration;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.fsm.States;
import org.neo4j.bolt.protocol.common.fsm.transition.authentication.AuthenticationStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.authentication.LogoffStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.negotiation.HelloStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.ready.CreateAutocommitStatementStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.ready.CreateTransactionStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.ready.RouteStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.transaction.CommitTransactionalStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.transaction.CreateStatementStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.transaction.RollbackTransactionalStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.transaction.streaming.AutocommitDiscardStreamingStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.transaction.streaming.AutocommitPullStreamingStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.transaction.streaming.DiscardResultsStreamingStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.transaction.streaming.PullResultsStreamingStateTransition;
import org.neo4j.bolt.protocol.common.message.decoder.authentication.DefaultHelloMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.authentication.DefaultLogoffMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.authentication.DefaultLogonMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.connection.DefaultGoodbyeMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.connection.DefaultResetMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.connection.DefaultRouteMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.streaming.DefaultDiscardMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.streaming.DefaultPullMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.transaction.DefaultBeginMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.transaction.DefaultCommitMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.transaction.DefaultRollbackMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.transaction.DefaultRunMessageDecoder;
import org.neo4j.bolt.protocol.common.message.encoder.FailureMessageEncoder;
import org.neo4j.bolt.protocol.common.message.encoder.IgnoredMessageEncoder;
import org.neo4j.bolt.protocol.common.message.encoder.SuccessMessageEncoder;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.response.ResponseMessage;
import org.neo4j.packstream.struct.StructRegistry;

public abstract class AbstractBoltProtocol
implements BoltProtocol {
    private final StateMachineConfiguration stateMachine = this.createStateMachine().build();
    private final StructRegistry<Connection, RequestMessage> requestMessageStructRegistry = this.createRequestMessageRegistry().build();
    private final StructRegistry<Connection, ResponseMessage> responseMessageStructRegistry = this.createResponseMessageRegistry().build();

    protected AbstractBoltProtocol() {
    }

    @Override
    public final StructRegistry<Connection, RequestMessage> requestMessageRegistry() {
        return this.requestMessageStructRegistry;
    }

    @Override
    public final StructRegistry<Connection, ResponseMessage> responseMessageRegistry() {
        return this.responseMessageStructRegistry;
    }

    @Override
    public StateMachineConfiguration stateMachine() {
        return this.stateMachine;
    }

    protected StateMachineConfiguration.Factory createStateMachine() {
        return StateMachineConfiguration.builder().withInitialState(States.NEGOTIATION, HelloStateTransition.getInstance()).withState(States.AUTHENTICATION, AuthenticationStateTransition.getInstance()).withState(States.READY, CreateTransactionStateTransition.getInstance(), RouteStateTransition.getInstance(), CreateAutocommitStatementStateTransition.getInstance(), LogoffStateTransition.getInstance()).withState(States.AUTO_COMMIT, AutocommitDiscardStreamingStateTransition.getInstance(), AutocommitPullStreamingStateTransition.getInstance()).withState(States.IN_TRANSACTION, CreateStatementStateTransition.getInstance(), DiscardResultsStreamingStateTransition.getInstance(), PullResultsStreamingStateTransition.getInstance(), CommitTransactionalStateTransition.getInstance(), RollbackTransactionalStateTransition.getInstance());
    }

    protected StructRegistry.Builder<Connection, RequestMessage> createRequestMessageRegistry() {
        return StructRegistry.builder().register(DefaultHelloMessageDecoder.getInstance()).register(DefaultLogonMessageDecoder.getInstance()).register(DefaultLogoffMessageDecoder.getInstance()).register(DefaultGoodbyeMessageDecoder.getInstance()).register(DefaultResetMessageDecoder.getInstance()).register(DefaultRouteMessageDecoder.getInstance()).register(DefaultDiscardMessageDecoder.getInstance()).register(DefaultPullMessageDecoder.getInstance()).register(DefaultBeginMessageDecoder.getInstance()).register(DefaultCommitMessageDecoder.getInstance()).register(DefaultRollbackMessageDecoder.getInstance()).register(DefaultRunMessageDecoder.getInstance());
    }

    protected StructRegistry.Builder<Connection, ResponseMessage> createResponseMessageRegistry() {
        return StructRegistry.builder().register(FailureMessageEncoder.getInstance()).register(IgnoredMessageEncoder.getInstance()).register(SuccessMessageEncoder.getInstance());
    }

    public String toString() {
        return this.version().toString();
    }
}

