/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.state.transition;

import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.fsm.state.transition.SequentialStateTransition;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;

public interface StateTransition<R extends RequestMessage> {
    public Class<R> requestType();

    public StateReference process(Context var1, R var2, ResponseHandler var3) throws StateMachineException;

    default public StateTransition<R> andThen(StateTransition<? super R> ... transitions) {
        if (transitions.length == 0) {
            return this;
        }
        if (transitions.length == 1) {
            return new SequentialStateTransition<R>(this.requestType(), this, transitions[0]);
        }
        StateTransition[] chain = new StateTransition[transitions.length + 1];
        chain[0] = this;
        System.arraycopy(transitions, 0, chain, 1, transitions.length);
        return new SequentialStateTransition<R>(this.requestType(), chain);
    }
}

