/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.throttle;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.transport.TransportThrottleException;

public class ChannelWriteThrottleHandler
extends ChannelDuplexHandler {
    private final List<ChannelPromise> pendingWriteOperations = new ArrayList<ChannelPromise>();
    private Future<?> reaperFuture;
    private final long maxWriteLockMillis;

    public ChannelWriteThrottleHandler(long maxWriteLockMillis) {
        this.maxWriteLockMillis = maxWriteLockMillis;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        super.write(ctx, msg, promise);
        this.pendingWriteOperations.add(promise);
        promise.addListener(future -> this.pendingWriteOperations.remove(promise));
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isWritable()) {
            if (this.reaperFuture != null) {
                this.reaperFuture.cancel(false);
                this.reaperFuture = null;
            }
        } else if (this.reaperFuture == null) {
            this.reaperFuture = ctx.executor().schedule(() -> {
                TransportThrottleException ex = new TransportThrottleException(this.maxWriteLockMillis);
                ArrayList<ChannelPromise> copyList = new ArrayList<ChannelPromise>(this.pendingWriteOperations);
                copyList.forEach(channelPromise -> channelPromise.setFailure((Throwable)ex));
                ctx.fireExceptionCaught((Throwable)ex);
            }, this.maxWriteLockMillis, TimeUnit.MILLISECONDS);
        }
        ctx.fireChannelWritabilityChanged();
    }
}

