/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v44;

import java.time.Clock;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPIImpl;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.v40.transaction.TransactionStateMachineSPIProviderV4;
import org.neo4j.bolt.protocol.v43.BoltProtocolV43;
import org.neo4j.bolt.protocol.v44.fsm.StateMachineV44;
import org.neo4j.bolt.protocol.v44.message.decoder.BeginMessageDecoder;
import org.neo4j.bolt.protocol.v44.message.decoder.RouteMessageDecoder;
import org.neo4j.bolt.protocol.v44.message.decoder.RunMessageDecoder;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.internal.LogService;
import org.neo4j.packstream.struct.StructRegistry;
import org.neo4j.time.SystemNanoClock;

public class BoltProtocolV44
extends BoltProtocolV43 {
    public static final ProtocolVersion VERSION = new ProtocolVersion(4, 4);

    public BoltProtocolV44(LogService logging, BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI, DefaultDatabaseResolver defaultDatabaseResolver, TransactionManager transactionManager, SystemNanoClock clock) {
        super(logging, boltGraphDatabaseManagementServiceSPI, defaultDatabaseResolver, transactionManager, clock);
    }

    @Override
    public ProtocolVersion version() {
        return VERSION;
    }

    @Override
    protected StructRegistry<Connection, RequestMessage> createRequestMessageRegistry() {
        return super.createRequestMessageRegistry().builderOf().register(BeginMessageDecoder.getInstance()).register(RouteMessageDecoder.getInstance()).register(RunMessageDecoder.getInstance()).build();
    }

    @Override
    public StateMachine createStateMachine(Connection connection) {
        connection.memoryTracker().allocateHeap(TransactionStateMachineSPIProviderV4.SHALLOW_SIZE + StateMachineSPIImpl.SHALLOW_SIZE + StateMachineV44.SHALLOW_SIZE);
        TransactionStateMachineSPIProviderV4 transactionSpiProvider = new TransactionStateMachineSPIProviderV4(this.boltGraphDatabaseManagementServiceSPI, connection, this.clock);
        StateMachineSPIImpl boltSPI = new StateMachineSPIImpl(this.logging, transactionSpiProvider);
        return new StateMachineV44(boltSPI, connection, (Clock)this.clock, this.defaultDatabaseResolver, this.transactionManager);
    }
}

