/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.transaction;

import java.time.Clock;
import org.neo4j.bolt.protocol.common.message.result.BoltResult;
import org.neo4j.bolt.protocol.common.transaction.AbstractCypherAdapterStream;
import org.neo4j.bolt.protocol.common.transaction.result.AdaptingBoltQuerySubscriber;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class CypherAdapterStreamV4
extends AbstractCypherAdapterStream {
    private static final String LAST_RESULT_CONSUMED_KEY = "t_last";
    private final String databaseName;

    public CypherAdapterStreamV4(QueryExecution delegate, AdaptingBoltQuerySubscriber subscriber, Clock clock, String databaseName) {
        super(delegate, subscriber, clock);
        this.databaseName = databaseName;
    }

    @Override
    protected void addRecordStreamingTime(long time, BoltResult.RecordConsumer recordConsumer) {
        recordConsumer.addMetadata(LAST_RESULT_CONSUMED_KEY, (AnyValue)Values.longValue((long)time));
    }

    @Override
    protected void addDatabaseName(BoltResult.RecordConsumer recordConsumer) {
        recordConsumer.addMetadata("db", (AnyValue)Values.utf8Value((String)this.databaseName));
    }
}

