/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.messaging.util;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.bookmark.BookmarkParser;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.impl.util.BaseToObjectValueWriter;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;

public final class MessageMetadataParserV40 {
    private static final String BOOKMARKS_KEY = "bookmarks";
    private static final String TX_TIMEOUT_KEY = "tx_timeout";
    private static final String TX_META_DATA_KEY = "tx_metadata";
    private static final String ACCESS_MODE_KEY = "mode";
    public static final String DB_NAME_KEY = "db";
    public static final String ABSENT_DB_NAME = "";
    private static final String STREAM_LIMIT_KEY = "n";
    private static final long STREAM_LIMIT_MINIMAL = 1L;
    public static final long STREAM_LIMIT_UNLIMITED = -1L;

    private MessageMetadataParserV40() {
    }

    public static List<Bookmark> parseBookmarks(BookmarkParser parser, MapValue meta) throws PackstreamReaderException {
        AnyValue anyValue = meta.get(BOOKMARKS_KEY);
        if (anyValue == Values.NO_VALUE) {
            return List.of();
        }
        if (anyValue instanceof ListValue) {
            ListValue listValue = (ListValue)anyValue;
            return parser.parseBookmarks((ListValue)anyValue);
        }
        throw new IllegalStructArgumentException(BOOKMARKS_KEY, "Expecting bookmarks value to be a List of strings, but got: " + anyValue);
    }

    public static Duration parseTransactionTimeout(MapValue meta) throws PackstreamReaderException {
        AnyValue anyValue = meta.get(TX_TIMEOUT_KEY);
        if (anyValue == Values.NO_VALUE) {
            return null;
        }
        if (anyValue instanceof LongValue) {
            LongValue longValue = (LongValue)anyValue;
            return Duration.ofMillis(longValue.longValue());
        }
        throw new IllegalStructArgumentException(TX_TIMEOUT_KEY, "Expecting transaction timeout value to be a Long value, but got: " + anyValue);
    }

    public static AccessMode parseAccessMode(MapValue meta) throws PackstreamReaderException {
        AnyValue anyValue = meta.get(ACCESS_MODE_KEY);
        if (anyValue == Values.NO_VALUE) {
            return AccessMode.WRITE;
        }
        if (anyValue instanceof StringValue) {
            StringValue stringValue = (StringValue)anyValue;
            return AccessMode.byFlag(stringValue.stringValue()).orElseThrow(() -> new IllegalStructArgumentException(ACCESS_MODE_KEY, "Expecting access mode value to be 'r' or 'w', but got: " + stringValue.stringValue()));
        }
        throw new IllegalStructArgumentException(ACCESS_MODE_KEY, "Expecting transaction access mode value to be a String value, but got: " + anyValue);
    }

    public static Map<String, Object> parseTransactionMetadata(MapValue meta) throws PackstreamReaderException {
        AnyValue anyValue = meta.get(TX_META_DATA_KEY);
        if (anyValue == Values.NO_VALUE) {
            return null;
        }
        if (anyValue instanceof MapValue) {
            MapValue mapValue = (MapValue)anyValue;
            TransactionMetadataWriter writer = new TransactionMetadataWriter();
            HashMap<String, Object> txMeta = new HashMap<String, Object>(mapValue.size());
            mapValue.foreach((key, value) -> txMeta.put((String)key, writer.valueAsObject((AnyValue)value)));
            return txMeta;
        }
        throw new IllegalStructArgumentException(TX_META_DATA_KEY, "Expecting transaction metadata value to be a Map value, but got: " + anyValue);
    }

    public static String parseDatabaseName(MapValue meta) throws PackstreamReaderException {
        AnyValue anyValue = meta.get(DB_NAME_KEY);
        if (anyValue == Values.NO_VALUE) {
            return ABSENT_DB_NAME;
        }
        if (anyValue instanceof StringValue) {
            return ((StringValue)anyValue).stringValue();
        }
        throw new IllegalStructArgumentException(DB_NAME_KEY, "Expecting database name value to be a String value, but got: " + anyValue);
    }

    public static long parseStreamLimit(MapValue meta) throws PackstreamReaderException {
        AnyValue anyValue = meta.get(STREAM_LIMIT_KEY);
        if (anyValue instanceof LongValue) {
            LongValue longValue = (LongValue)anyValue;
            long size = longValue.longValue();
            if (size != -1L && size < 1L) {
                throw new IllegalStructArgumentException(STREAM_LIMIT_KEY, String.format("Expecting size to be at least %s, but got: %s", 1L, size));
            }
            return size;
        }
        throw new IllegalStructArgumentException(STREAM_LIMIT_KEY, String.format("Expecting size to be a Long value, but got: %s", anyValue));
    }

    public static int parseStatementId(MapValue meta) throws PackstreamReaderException {
        AnyValue anyValue = meta.get("qid");
        if (anyValue == Values.NO_VALUE) {
            return -1;
        }
        if (anyValue instanceof LongValue) {
            LongValue longValue = (LongValue)anyValue;
            return Math.toIntExact(longValue.longValue());
        }
        throw new IllegalStructArgumentException("qid", String.format("Expecting statement id to be a Long value, but got: %s", anyValue));
    }

    private static class TransactionMetadataWriter
    extends BaseToObjectValueWriter<RuntimeException> {
        private TransactionMetadataWriter() {
        }

        protected Node newNodeEntityById(long id) {
            throw new UnsupportedOperationException("Transaction metadata should not contain nodes");
        }

        protected Node newNodeEntityByElementId(String elementId) {
            throw new UnsupportedOperationException("Transaction metadata should not contain nodes");
        }

        protected Relationship newRelationshipEntityById(long id) {
            throw new UnsupportedOperationException("Transaction metadata should not contain relationships");
        }

        protected Relationship newRelationshipEntityByElementId(String elementId) {
            throw new UnsupportedOperationException("Transaction metadata should not contain relationships");
        }

        protected Point newPoint(CoordinateReferenceSystem crs, double[] coordinate) {
            return Values.pointValue((CoordinateReferenceSystem)crs, (double[])coordinate);
        }

        Object valueAsObject(AnyValue value) {
            value.writeTo((AnyValueWriter)this);
            return this.value();
        }
    }
}

