/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.messaging.request;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.values.virtual.MapValue;

public abstract class TransactionInitiatingMessage
implements RequestMessage {
    private final MapValue meta;
    private final List<Bookmark> bookmarks;
    private final Duration txTimeout;
    private final AccessMode accessMode;
    private final Map<String, Object> txMetadata;
    private final String databaseName;

    public TransactionInitiatingMessage() {
        this(MapValue.EMPTY, List.of(), null, AccessMode.WRITE, Map.of(), "");
    }

    public TransactionInitiatingMessage(MapValue meta, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, String databaseName) {
        this.meta = meta;
        this.bookmarks = bookmarks;
        this.txTimeout = txTimeout;
        this.accessMode = accessMode;
        this.txMetadata = txMetadata;
        this.databaseName = databaseName;
    }

    public List<Bookmark> bookmarks() {
        return this.bookmarks;
    }

    public Duration transactionTimeout() {
        return this.txTimeout;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public Map<String, Object> transactionMetadata() {
        return this.txMetadata;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public MapValue meta() {
        return this.meta;
    }

    @Override
    public boolean safeToProcessInAnyState() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionInitiatingMessage that = (TransactionInitiatingMessage)o;
        return Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        return Objects.hash(this.meta);
    }
}

