/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.fsm;

import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.result.ResultConsumer;
import org.neo4j.bolt.protocol.common.transaction.statement.metadata.StatementMetadata;
import org.neo4j.bolt.protocol.v40.fsm.AbstractStreamingState;
import org.neo4j.bolt.protocol.v40.messaging.request.CommitMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.RollbackMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.RunMessage;
import org.neo4j.bolt.security.error.AuthenticationException;
import org.neo4j.bolt.transaction.TransactionNotFoundException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class InTransactionState
extends AbstractStreamingState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(InTransactionState.class);
    public static final String QUERY_ID_KEY = "qid";

    @Override
    protected State processUnsafe(RequestMessage message, StateMachineContext context) throws Throwable {
        context.connectionState().ensureNoPendingTerminationNotice();
        if (message == CommitMessage.INSTANCE) {
            return this.processCommitMessage(context);
        }
        if (message == RollbackMessage.INSTANCE) {
            return this.processRollbackMessage(context);
        }
        if (message instanceof RunMessage) {
            RunMessage runMessage = (RunMessage)message;
            return this.processRunMessage(runMessage, context);
        }
        return super.processUnsafe(message, context);
    }

    @Override
    public String name() {
        return "IN_TRANSACTION";
    }

    @Override
    protected State processStreamPullResultMessage(int statementId, ResultConsumer resultConsumer, StateMachineContext context, long noToPull) throws Throwable {
        context.transactionManager().pullData(context.connectionState().getCurrentTransactionId(), statementId, noToPull, resultConsumer);
        return this;
    }

    @Override
    protected State processStreamDiscardResultMessage(int statementId, ResultConsumer resultConsumer, StateMachineContext context, long noToDiscard) throws Throwable {
        context.transactionManager().discardData(context.connectionState().getCurrentTransactionId(), statementId, noToDiscard, resultConsumer);
        return this;
    }

    private State processRunMessage(RunMessage message, StateMachineContext context) throws KernelException, TransactionNotFoundException {
        context.connectionState().ensureNoPendingTerminationNotice();
        long start = context.clock().millis();
        StatementMetadata metadata = context.transactionManager().runQuery(context.connectionState().getCurrentTransactionId(), message.statement(), message.params());
        long end = context.clock().millis();
        context.connectionState().onMetadata("fields", (AnyValue)Values.stringArray((String[])metadata.fieldNames()));
        context.connectionState().onMetadata("t_first", (AnyValue)Values.longValue((long)(end - start)));
        context.connectionState().onMetadata(QUERY_ID_KEY, (AnyValue)Values.longValue((long)metadata.queryId()));
        return this;
    }

    protected State processCommitMessage(StateMachineContext context) throws KernelException, TransactionNotFoundException, AuthenticationException {
        Bookmark bookmark = context.transactionManager().commit(context.connectionState().getCurrentTransactionId());
        context.connectionState().clearCurrentTransactionId();
        bookmark.attachTo(context.connectionState());
        return this.readyState;
    }

    protected State processRollbackMessage(StateMachineContext context) throws KernelException, TransactionNotFoundException, AuthenticationException {
        context.transactionManager().rollback(context.connectionState().getCurrentTransactionId());
        context.connectionState().clearCurrentTransactionId();
        return this.readyState;
    }
}

