/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.transaction.result;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.Error;
import org.neo4j.bolt.protocol.common.message.encoder.DiscardingRecordMessageWriter;
import org.neo4j.bolt.protocol.common.message.encoder.RecordMessageWriter;
import org.neo4j.bolt.protocol.common.message.response.FailureMessage;
import org.neo4j.bolt.protocol.common.message.response.IgnoredMessage;
import org.neo4j.bolt.protocol.common.message.response.SuccessMessage;
import org.neo4j.bolt.protocol.common.message.result.BoltResult;
import org.neo4j.bolt.protocol.common.message.result.ResponseHandler;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;

public class ResultHandler
implements ResponseHandler {
    private static final Set<Status> CLIENT_MID_OP_DISCONNECT_ERRORS = new HashSet<Status.Transaction>(Arrays.asList(Status.Transaction.Terminated, Status.Transaction.LockClientStopped));
    private final MapValueBuilder metadata = new MapValueBuilder();
    protected final Log log;
    protected final Connection connection;
    private Error error;
    private boolean ignored;

    public ResultHandler(Connection connection, InternalLogProvider logging) {
        this.connection = connection;
        this.log = logging.getLog(ResultHandler.class);
    }

    @Override
    public boolean onPullRecords(BoltResult result, long size) throws Throwable {
        return this.markHasMore(result.handleRecords(new RecordMessageWriter(this.connection, this), size));
    }

    @Override
    public boolean onDiscardRecords(BoltResult result, long size) throws Throwable {
        return this.markHasMore(result.discardRecords(new DiscardingRecordMessageWriter(this), size));
    }

    @Override
    public void onMetadata(String key, AnyValue value) {
        this.metadata.add(key, value);
    }

    @Override
    public void markIgnored() {
        this.ignored = true;
    }

    @Override
    public void markFailed(Error error) {
        this.error = error;
    }

    @Override
    public void onFinish() {
        try {
            if (this.ignored) {
                this.connection.channel().writeAndFlush((Object)IgnoredMessage.INSTANCE).sync();
            } else if (this.error != null) {
                this.publishError(this.error);
            } else {
                this.connection.channel().writeAndFlush((Object)new SuccessMessage(this.getMetadata())).sync();
            }
        }
        catch (Throwable e) {
            this.connection.close();
            this.log.error("Failed to write response to driver", e);
        }
        finally {
            this.clearState();
        }
    }

    private MapValue getMetadata() {
        return this.metadata.build();
    }

    private void clearState() {
        this.error = null;
        this.ignored = false;
        this.metadata.clear();
    }

    private boolean markHasMore(boolean hasMore) {
        if (hasMore) {
            this.onMetadata("has_more", (AnyValue)BooleanValue.TRUE);
        }
        return hasMore;
    }

    private void publishError(Error error) {
        if (error.isFatal()) {
            this.log.debug("Publishing fatal error: %s", new Object[]{error});
        }
        Channel ch = this.connection.channel();
        SocketAddress remoteAddress = ch.remoteAddress();
        ch.writeAndFlush((Object)new FailureMessage(error.status(), error.message(), error.isFatal())).addListener(f -> {
            if (f.isSuccess()) {
                return;
            }
            if (CLIENT_MID_OP_DISCONNECT_ERRORS.contains(error.status())) {
                this.log.warn("Client %s disconnected while query was running. Session has been cleaned up. This can be caused by temporary network problems, but if you see this often, ensure your applications are properly waiting for operations to complete before exiting.", new Object[]{remoteAddress});
                return;
            }
            Throwable ex = f.cause();
            ex.addSuppressed(error.cause());
            this.log.warn("Unable to send error back to the client. " + ex.getMessage(), ex);
        });
    }
}

