/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.encoder;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.result.BoltResult;
import org.neo4j.bolt.protocol.common.message.result.ResponseHandler;
import org.neo4j.bolt.protocol.common.signal.MessageSignal;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.values.AnyValue;

public class RecordMessageWriter
implements BoltResult.RecordConsumer {
    public static final short RECORD_TAG = 113;
    private final Connection connection;
    private final ResponseHandler parent;

    public RecordMessageWriter(Connection connection, ResponseHandler parent) {
        this.connection = connection;
        this.parent = parent;
    }

    private void write(Consumer<PackstreamBuf> consumer) throws IOException {
        ByteBuf buf = this.connection.channel().alloc().buffer();
        consumer.accept(PackstreamBuf.wrap(buf));
        this.connection.write(buf).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    @Override
    public void beginRecord(int numberOfFields) throws IOException {
        this.write(buf -> buf.writeStructHeader(new StructHeader(1L, 113)).writeListHeader(numberOfFields));
    }

    @Override
    public void consumeField(AnyValue value) throws IOException {
        this.write(b -> this.connection.writerContext((PackstreamBuf)b).writeValue(value));
    }

    @Override
    public void endRecord() throws IOException {
        this.connection.write((Object)MessageSignal.END).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    @Override
    public void onError() throws IOException {
        this.connection.write((Object)MessageSignal.RESET).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    @Override
    public void addMetadata(String key, AnyValue value) {
        this.parent.onMetadata(key, value);
    }
}

