/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;

@ChannelHandler.Sharable
public class ProtocolLoggingHandler
extends ChannelDuplexHandler {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ProtocolLoggingHandler.class);
    private final InternalLog log;

    public ProtocolLoggingHandler(InternalLogProvider logging) {
        this(logging.getLog(ProtocolLoggingHandler.class));
    }

    public ProtocolLoggingHandler(InternalLog log) {
        this.log = log;
    }

    public static void shiftToEndIfPresent(ChannelHandlerContext ctx) {
        ProtocolLoggingHandler handler = (ProtocolLoggingHandler)ctx.pipeline().get(ProtocolLoggingHandler.class);
        if (handler == null) {
            return;
        }
        ctx.pipeline().remove((ChannelHandler)handler);
        ctx.pipeline().addLast(new ChannelHandler[]{handler});
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            this.log.info("[%s] >>> Blob (%d bytes):\n%s", new Object[]{ctx.channel().remoteAddress(), buf.readableBytes(), ByteBufUtil.prettyHexDump((ByteBuf)buf)});
        } else {
            this.log.info("[%s] >>> %s", new Object[]{ctx.channel().remoteAddress(), msg});
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            this.log.info("[%s] <<< Blob (%d bytes):\n%s", new Object[]{ctx.channel().remoteAddress(), buf.readableBytes(), ByteBufUtil.prettyHexDump((ByteBuf)buf)});
        } else {
            this.log.info("[%s] <<< %s", new Object[]{ctx.channel().remoteAddress(), msg});
        }
        super.write(ctx, msg, promise);
    }
}

