/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm;

import java.time.Clock;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.MutableConnectionState;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPI;
import org.neo4j.bolt.protocol.common.transaction.TransactionStateMachineSPIProvider;
import org.neo4j.bolt.protocol.common.transaction.statement.StatementProcessorProvider;
import org.neo4j.bolt.protocol.common.transaction.statement.StatementProcessorReleaseManager;
import org.neo4j.bolt.protocol.v41.message.request.RoutingContext;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.transaction.CleanUpTransactionContext;
import org.neo4j.bolt.transaction.InitializeContext;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.memory.HeapEstimator;

public class StateMachineContextImpl
implements StateMachineContext,
StatementProcessorReleaseManager {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(StateMachineContextImpl.class);
    private final Connection connection;
    private final StateMachine machine;
    private final StateMachineSPI spi;
    private final MutableConnectionState connectionState;
    private final Clock clock;
    private final TransactionManager transactionManager;

    public StateMachineContextImpl(Connection connection, StateMachine machine, StateMachineSPI spi, MutableConnectionState connectionState, Clock clock, TransactionManager transactionManager) {
        this.connection = connection;
        this.machine = machine;
        this.spi = spi;
        this.connectionState = connectionState;
        this.clock = clock;
        this.transactionManager = transactionManager;
    }

    @Override
    public String connectionId() {
        return this.connection.id();
    }

    @Override
    public Connection connection() {
        return this.connection;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public TransactionManager transactionManager() {
        return this.transactionManager;
    }

    @Override
    public StateMachineSPI boltSpi() {
        return this.spi;
    }

    @Override
    public MutableConnectionState connectionState() {
        return this.connectionState;
    }

    @Override
    public void handleFailure(Throwable cause, boolean fatal) throws BoltConnectionFatality {
        this.machine.handleFailure(cause, fatal);
    }

    @Override
    public boolean resetMachine() throws BoltConnectionFatality {
        return this.machine.reset();
    }

    @Override
    public void initStatementProcessorProvider(RoutingContext routingContext) {
        TransactionStateMachineSPIProvider transactionSpiProvider = this.spi.transactionStateMachineSPIProvider();
        StatementProcessorProvider statementProcessorProvider = new StatementProcessorProvider(transactionSpiProvider, this.clock, this, routingContext, this.connection.memoryTracker());
        InitializeContext initializeContext = new InitializeContext(this.connectionId(), statementProcessorProvider);
        this.transactionManager.initialize(initializeContext);
    }

    @Override
    public void releaseStatementProcessor(String transactionId) {
        this.transactionManager.cleanUp(new CleanUpTransactionContext(transactionId));
        this.connectionState.clearCurrentTransactionId();
    }
}

