/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import java.net.SocketAddress;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.bookmark.BookmarkParser;
import org.neo4j.bolt.protocol.common.connection.ConnectionHintProvider;
import org.neo4j.bolt.protocol.common.connector.AbstractConnector;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.security.Authentication;
import org.neo4j.configuration.helpers.PortBindException;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.server.config.AuthConfigProvider;

public abstract class AbstractNettyConnector
extends AbstractConnector {
    protected final SocketAddress bindAddress;
    protected final InternalLog userLog;
    protected final InternalLog log;
    private Channel channel;

    AbstractNettyConnector(String id, SocketAddress bindAddress, MemoryPool memoryPool, Connection.Factory connectionFactory, NetworkConnectionTracker connectionTracker, boolean encryptionRequired, BoltProtocolRegistry protocolRegistry, Authentication authentication, AuthConfigProvider authConfigProvider, DefaultDatabaseResolver defaultDatabaseResolver, ConnectionHintProvider connectionHintProvider, BookmarkParser bookmarkParser, InternalLogProvider userLogProvider, InternalLogProvider internalLogProvider) {
        super(id, memoryPool, connectionFactory, connectionTracker, encryptionRequired, protocolRegistry, authentication, authConfigProvider, defaultDatabaseResolver, connectionHintProvider, bookmarkParser, internalLogProvider);
        this.bindAddress = bindAddress;
        this.userLog = userLogProvider.getLog(this.getClass());
        this.log = internalLogProvider.getLog(this.getClass());
    }

    protected EventLoopGroup bossGroup() {
        return this.workerGroup();
    }

    protected abstract EventLoopGroup workerGroup();

    protected abstract Class<? extends ServerChannel> channelType();

    protected void configureServer(ServerBootstrap bootstrap) {
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE);
    }

    protected void onChannelBound(Channel channel) {
    }

    protected void onChannelClose(Channel channel) {
    }

    protected abstract ChannelInitializer<Channel> channelInitializer();

    @Override
    public SocketAddress address() {
        Channel channel = this.channel;
        if (channel == null) {
            return null;
        }
        return channel.localAddress();
    }

    @Override
    public void start() throws Exception {
        if (this.channel != null) {
            throw new IllegalStateException("Connector " + this.id() + " is already running");
        }
        this.onStart();
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().channel(this.channelType())).group(this.bossGroup(), this.workerGroup()).childHandler(this.channelInitializer());
        this.configureServer(bootstrap);
        ChannelFuture f = bootstrap.bind(this.bindAddress);
        try {
            f.await();
        }
        catch (InterruptedException ex) {
            throw new PortBindException(this.bindAddress, (Throwable)ex);
        }
        if (!f.isSuccess()) {
            throw new PortBindException(this.bindAddress, f.cause());
        }
        this.channel = f.channel();
        this.onChannelBound(this.channel);
        this.logStartupMessage();
    }

    protected void onStart() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        Channel channel = this.channel;
        if (channel == null) {
            return;
        }
        super.stop();
        this.onChannelClose(channel);
        ChannelFuture f = channel.close().awaitUninterruptibly();
        if (!f.isSuccess()) {
            this.log.warn("Failed to close channel " + channel + " for connector " + this.id(), f.cause());
        }
    }

    protected void logStartupMessage() {
    }
}

