/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.connection;

import org.neo4j.bolt.protocol.common.message.Error;
import org.neo4j.bolt.protocol.common.message.result.BoltResult;
import org.neo4j.bolt.protocol.common.message.result.ResponseHandler;
import org.neo4j.bolt.runtime.BoltProtocolBreachFatality;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;

public class MutableConnectionState
implements ResponseHandler {
    private Error pendingError;
    private boolean pendingIgnore;
    private volatile boolean terminated;
    private boolean closed;
    private volatile String currentTransactionId;
    private ResponseHandler responseHandler;
    private Status pendingTerminationNotice;

    @Override
    public boolean onPullRecords(BoltResult result, long size) throws Throwable {
        if (this.responseHandler != null) {
            return this.responseHandler.onPullRecords(result, size);
        }
        return false;
    }

    @Override
    public boolean onDiscardRecords(BoltResult result, long size) throws Throwable {
        if (this.responseHandler != null) {
            return this.responseHandler.onDiscardRecords(result, size);
        }
        return false;
    }

    @Override
    public void onMetadata(String key, AnyValue value) {
        if (this.responseHandler != null) {
            this.responseHandler.onMetadata(key, value);
        }
    }

    @Override
    public void markIgnored() {
        if (this.responseHandler != null) {
            this.responseHandler.markIgnored();
        } else {
            this.pendingIgnore = true;
        }
    }

    @Override
    public void markFailed(Error error) {
        if (this.responseHandler != null) {
            this.responseHandler.markFailed(error);
        } else {
            this.pendingError = error;
        }
    }

    @Override
    public void onFinish() {
        if (this.responseHandler != null) {
            this.responseHandler.onFinish();
        }
    }

    public Error getPendingError() {
        return this.pendingError;
    }

    public boolean hasPendingIgnore() {
        return this.pendingIgnore;
    }

    public void resetPendingFailedAndIgnored() {
        this.pendingError = null;
        this.pendingIgnore = false;
        this.pendingTerminationNotice = null;
    }

    public boolean canProcessMessage() {
        return !this.closed && this.pendingError == null && !this.pendingIgnore;
    }

    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public void setResponseHandler(ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    public void setPendingTerminationNotice(Status terminationNotice) {
        this.pendingTerminationNotice = terminationNotice;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void markTerminated() {
        this.terminated = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void markClosed() {
        this.closed = true;
    }

    public void ensureNoPendingTerminationNotice() {
        if (this.pendingTerminationNotice != null) {
            Status status = this.pendingTerminationNotice;
            this.pendingTerminationNotice = null;
            throw new TransactionTerminatedException(status);
        }
    }

    public void setCurrentTransactionId(String transactionId) throws BoltProtocolBreachFatality {
        if (this.currentTransactionId != null) {
            throw new BoltProtocolBreachFatality("Cannot assign new transaction id without clearing the old id: " + this.currentTransactionId);
        }
        this.currentTransactionId = transactionId;
    }

    public void clearCurrentTransactionId() {
        this.currentTransactionId = null;
    }

    public String getCurrentTransactionId() {
        return this.currentTransactionId;
    }
}

