/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.connection.Job;
import org.neo4j.bolt.protocol.common.connector.Connector;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.common.connector.connection.authentication.AuthenticationFlag;
import org.neo4j.bolt.protocol.common.connector.connection.listener.ConnectionListener;
import org.neo4j.bolt.protocol.common.connector.tx.TransactionOwner;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.result.ResponseHandler;
import org.neo4j.bolt.protocol.io.pipeline.PipelineContext;
import org.neo4j.bolt.security.error.AuthenticationException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;

public interface Connection
extends TrackedNetworkConnection,
TransactionOwner {
    public static final AttributeKey<Connection> CONNECTION_ATTR = AttributeKey.valueOf(Connection.class, (String)"connection");

    public static Connection getConnection(Channel channel) {
        Connection connection = (Connection)channel.attr(CONNECTION_ATTR).get();
        Objects.requireNonNull(connection, "connection");
        return connection;
    }

    public static void setAttribute(Channel channel, Connection connection) {
        channel.attr(CONNECTION_ATTR).set((Object)connection);
    }

    public Connector connector();

    default public String connectorId() {
        return this.connector().id();
    }

    public Channel channel();

    default public ChannelFuture write(Object msg) {
        return this.channel().write(msg);
    }

    default public ChannelFuture write(Object msg, ChannelPromise promise) {
        return this.channel().write(msg, promise);
    }

    default public ChannelFuture writeAndFlush(Object msg) {
        return this.channel().writeAndFlush(msg);
    }

    default public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        return this.channel().writeAndFlush(msg, promise);
    }

    public void registerListener(ConnectionListener var1);

    public void removeListener(ConnectionListener var1);

    public void notifyListeners(Consumer<ConnectionListener> var1);

    public void notifyListenersSafely(String var1, Consumer<ConnectionListener> var2);

    public BoltProtocol protocol();

    public void selectProtocol(BoltProtocol var1);

    public PackstreamValueReader<Connection> valueReader(PackstreamBuf var1);

    public PipelineContext writerContext(PackstreamBuf var1);

    public boolean enableFeature(Feature var1);

    public StateMachine fsm();

    public LoginContext loginContext();

    public AuthenticationFlag authenticate(Map<String, Object> var1, String var2) throws AuthenticationException;

    public void impersonate(String var1) throws AuthenticationException;

    public void resolveDefaultDatabase();

    public boolean isIdling();

    public boolean hasPendingJobs();

    public void submit(RequestMessage var1, ResponseHandler var2);

    public void submit(Job var1);

    public boolean isInterrupted();

    public void interrupt();

    public boolean reset();

    public boolean isClosing();

    public boolean isClosed();

    public void close();

    public Future<?> closeFuture();

    public static interface Factory {
        public Connection create(Connector var1, String var2, Channel var3);
    }
}

