/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.common.connection.ConnectionHintProvider;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.response.ResponseMessage;
import org.neo4j.bolt.protocol.io.pipeline.WriterPipeline;
import org.neo4j.bolt.protocol.io.writer.DefaultStructWriter;
import org.neo4j.packstream.signal.FrameSignal;
import org.neo4j.packstream.struct.StructRegistry;
import org.neo4j.values.storable.Value;

public interface BoltProtocol {
    public ProtocolVersion version();

    default public Set<Feature> features() {
        return Collections.emptySet();
    }

    default public ConnectionHintProvider connectionHintProvider() {
        return ConnectionHintProvider.noop();
    }

    default public Predicate<FrameSignal> frameSignalFilter() {
        return signal -> false;
    }

    public StateMachine createStateMachine(Connection var1);

    public StructRegistry<Connection, RequestMessage> requestMessageRegistry();

    public StructRegistry<Connection, ResponseMessage> responseMessageRegistry();

    public void registerStructReaders(StructRegistry.Builder<Connection, Value> var1);

    default public void registerStructWriters(WriterPipeline pipeline) {
        pipeline.addLast(DefaultStructWriter.getInstance());
    }
}

