/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.dbapi.impl;

import java.time.Duration;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.impl.BoltKernelGraphDatabaseServiceProvider;
import org.neo4j.bolt.txtracking.TransactionIdTracker;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.time.SystemNanoClock;

public class BoltKernelDatabaseManagementServiceProvider
implements BoltGraphDatabaseManagementServiceSPI {
    private final DatabaseManagementService managementService;
    private final TransactionIdTracker transactionIdTracker;
    private final Duration bookmarkAwaitDuration;

    public BoltKernelDatabaseManagementServiceProvider(DatabaseManagementService managementService, Monitors monitors, SystemNanoClock clock, Duration bookmarkAwaitDuration) {
        this.managementService = managementService;
        this.transactionIdTracker = new TransactionIdTracker(managementService, monitors, clock);
        this.bookmarkAwaitDuration = bookmarkAwaitDuration;
    }

    @Override
    public BoltGraphDatabaseServiceSPI database(String databaseName, MemoryTracker memoryTracker) throws DatabaseNotFoundException, UnavailableException {
        memoryTracker.allocateHeap(BoltKernelGraphDatabaseServiceProvider.SHALLOW_SIZE);
        GraphDatabaseAPI databaseAPI = (GraphDatabaseAPI)this.managementService.database(databaseName);
        if (!databaseAPI.isAvailable()) {
            throw new UnavailableException(String.format("Database '%s' is unavailable.", databaseName));
        }
        return new BoltKernelGraphDatabaseServiceProvider(databaseAPI, this.transactionIdTracker, this.bookmarkAwaitDuration, memoryTracker);
    }
}

