/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v41.messaging;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.messaging.ResponseMessage;
import org.neo4j.bolt.packstream.Neo4jPackV3;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.packstream.PackProvider;
import org.neo4j.bolt.v3.messaging.BoltResponseMessageWriterV3;
import org.neo4j.bolt.v41.messaging.MessageWriterTimer;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.AnyValue;

public class BoltResponseMessageWriterV41
implements BoltResponseMessageWriter {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(BoltResponseMessageWriterV41.class);
    private final BoltResponseMessageWriterV3 delegator;
    private final MessageWriterTimer timer;
    private boolean inRecord;
    private boolean shouldFlushAfterRecord;
    private boolean closed;
    private final Lock lock = new ReentrantLock();

    public BoltResponseMessageWriterV41(PackProvider packerProvider, PackOutput output, LogService logService, SystemNanoClock clock, Duration keepAliveInterval) {
        this(new BoltResponseMessageWriterV3(packerProvider, output, logService), new MessageWriterTimer(clock, keepAliveInterval));
    }

    BoltResponseMessageWriterV41(BoltResponseMessageWriterV3 writer, MessageWriterTimer timer) {
        this.delegator = writer;
        this.timer = timer;
    }

    @Override
    public void write(ResponseMessage message) throws IOException {
        this.lock.lock();
        try {
            this.delegator.write(message);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.lock.lock();
        try {
            this.timer.reset();
            this.delegator.flush();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void keepAlive() throws IOException {
        if (!this.closed && this.timer.isTimedOut() && this.lock.tryLock()) {
            try {
                if (!this.closed && this.timer.isTimedOut()) {
                    this.flushBufferOrSendKeepAlive();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void initKeepAliveTimer() {
        this.timer.reset();
    }

    @Override
    public void beginRecord(int numberOfFields) throws IOException {
        this.lock.lock();
        try {
            this.beforeRecord();
            this.delegator.beginRecord(numberOfFields);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void consumeField(AnyValue value) throws IOException {
        this.lock.lock();
        try {
            this.delegator.consumeField(value);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void endRecord() throws IOException {
        this.lock.lock();
        try {
            this.delegator.endRecord();
            this.afterRecord();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onError() throws IOException {
        this.lock.lock();
        try {
            this.delegator.onError();
            this.afterRecord();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.closed = true;
            this.delegator.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void beforeRecord() {
        this.inRecord = true;
    }

    private void afterRecord() throws IOException {
        this.inRecord = false;
        if (this.shouldFlushAfterRecord) {
            this.flush();
        }
    }

    @Override
    public void flushBufferOrSendKeepAlive() throws IOException {
        this.lock.lock();
        try {
            this.doFlushBufferOrSendKeepAlive();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doFlushBufferOrSendKeepAlive() throws IOException {
        if (this.inRecord) {
            this.shouldFlushAfterRecord = true;
            return;
        }
        this.writeNoop();
        this.flush();
    }

    private void writeNoop() throws IOException {
        try {
            this.delegator.output().beginMessage();
            this.delegator.output().messageSucceeded();
        }
        catch (Throwable e) {
            this.delegator.log().error("Failed to write NOOP", e);
            throw e;
        }
    }

    @Override
    public void handle(List<String> patches) {
        if (patches.contains("utc")) {
            this.delegator.updatePacker(new Neo4jPackV3());
        }
    }
}

