/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;

public class KeepAliveHandler
extends IdleStateHandler {
    private final BoltResponseMessageWriter messageWriter;
    private volatile boolean active;

    public KeepAliveHandler(long writerIdleTimeSeconds, BoltResponseMessageWriter messageWriter) {
        super(0L, writerIdleTimeSeconds, 0L, TimeUnit.MILLISECONDS);
        this.messageWriter = messageWriter;
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        if (!this.active) {
            return;
        }
        this.messageWriter.flushBufferOrSendKeepAlive();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

