/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.request;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.runtime.AccessMode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.BaseToObjectValueWriter;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class MessageMetadataParser {
    private static final String TX_TIMEOUT_KEY = "tx_timeout";
    private static final String TX_META_DATA_KEY = "tx_metadata";
    private static final String ACCESS_MODE_KEY = "mode";

    private MessageMetadataParser() {
    }

    public static Duration parseTransactionTimeout(MapValue meta) throws BoltIOException {
        AnyValue anyValue = meta.get(TX_TIMEOUT_KEY);
        if (anyValue == Values.NO_VALUE) {
            return null;
        }
        if (anyValue instanceof LongValue) {
            return Duration.ofMillis(((LongValue)anyValue).longValue());
        }
        throw new BoltIOException((Status)Status.Request.Invalid, "Expecting transaction timeout value to be a Long value, but got: " + anyValue);
    }

    public static AccessMode parseAccessMode(MapValue meta) throws BoltIOException {
        AnyValue anyValue = meta.get(ACCESS_MODE_KEY);
        if (anyValue == Values.NO_VALUE) {
            return AccessMode.WRITE;
        }
        if (anyValue instanceof StringValue) {
            String value = ((StringValue)anyValue).stringValue();
            if (value.equals("r")) {
                return AccessMode.READ;
            }
            if (value.equals("w")) {
                return AccessMode.WRITE;
            }
            throw new BoltIOException((Status)Status.Request.Invalid, "Expecting access mode value to be 'r' or 'w', but got: " + anyValue);
        }
        throw new BoltIOException((Status)Status.Request.Invalid, "Expecting access mode value to be a String value, but got: " + anyValue);
    }

    public static Map<String, Object> parseTransactionMetadata(MapValue meta) throws BoltIOException {
        AnyValue anyValue = meta.get(TX_META_DATA_KEY);
        if (anyValue == Values.NO_VALUE) {
            return null;
        }
        if (anyValue instanceof MapValue) {
            MapValue mapValue = (MapValue)anyValue;
            TransactionMetadataWriter writer = new TransactionMetadataWriter();
            HashMap<String, Object> txMeta = new HashMap<String, Object>(mapValue.size());
            mapValue.foreach((key, value) -> txMeta.put((String)key, writer.valueAsObject((AnyValue)value)));
            return txMeta;
        }
        throw new BoltIOException((Status)Status.Request.Invalid, "Expecting transaction metadata value to be a Map value, but got: " + anyValue);
    }

    private static class TransactionMetadataWriter
    extends BaseToObjectValueWriter<RuntimeException> {
        private TransactionMetadataWriter() {
        }

        protected Node newNodeEntityById(long id) {
            throw new UnsupportedOperationException("Transaction metadata should not contain nodes");
        }

        protected Relationship newRelationshipEntityById(long id) {
            throw new UnsupportedOperationException("Transaction metadata should not contain relationships");
        }

        protected Point newPoint(CoordinateReferenceSystem crs, double[] coordinate) {
            return Values.pointValue((CoordinateReferenceSystem)crs, (double[])coordinate);
        }

        Object valueAsObject(AnyValue value) {
            value.writeTo((AnyValueWriter)this);
            return this.value();
        }
    }
}

