/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.ResultConsumer;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.v3.runtime.FailSafeBoltStateMachineState;
import org.neo4j.bolt.v4.messaging.DiscardMessage;
import org.neo4j.bolt.v4.messaging.DiscardResultConsumer;
import org.neo4j.bolt.v4.messaging.PullMessage;
import org.neo4j.bolt.v4.messaging.PullResultConsumer;
import org.neo4j.util.Preconditions;

public abstract class AbstractStreamingState
extends FailSafeBoltStateMachineState {
    protected BoltStateMachineState readyState;

    @Override
    protected BoltStateMachineState processUnsafe(RequestMessage message, StateMachineContext context) throws Throwable {
        if (message instanceof PullMessage) {
            PullMessage pullMessage = (PullMessage)message;
            return this.processStreamResultMessage(pullMessage.statementId(), new PullResultConsumer(context, pullMessage.n()), context);
        }
        if (message instanceof DiscardMessage) {
            DiscardMessage discardMessage = (DiscardMessage)message;
            return this.processStreamResultMessage(discardMessage.statementId(), new DiscardResultConsumer(context, discardMessage.n()), context);
        }
        return null;
    }

    public void setReadyState(BoltStateMachineState readyState) {
        this.readyState = readyState;
    }

    protected abstract BoltStateMachineState processStreamResultMessage(int var1, ResultConsumer var2, StateMachineContext var3) throws Throwable;

    @Override
    protected void assertInitialized() {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
        super.assertInitialized();
    }
}

