/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.packstream.ByteBufInput;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.UnpackerProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.HeapEstimator;

public class MessageDecoder
extends SimpleChannelInboundHandler<ByteBuf> {
    public static long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(MessageDecoder.class);
    private final ByteBufInput input = new ByteBufInput();
    private final Neo4jPack.Unpacker unpacker;
    private final BoltRequestMessageReader reader;
    private final Log log;

    public MessageDecoder(UnpackerProvider unpackProvider, BoltRequestMessageReader reader, LogService logService) {
        this.unpacker = unpackProvider.newUnpacker(this.input);
        this.reader = reader;
        this.log = logService.getInternalLog(((Object)((Object)this)).getClass());
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Exception {
        this.input.start(byteBuf);
        byteBuf.markReaderIndex();
        try {
            this.reader.read(this.unpacker);
        }
        catch (Throwable error) {
            this.logMessageOnError(byteBuf);
            throw error;
        }
        finally {
            this.input.stop();
        }
    }

    private void logMessageOnError(ByteBuf byteBuf) {
        byteBuf.resetReaderIndex();
        this.log.error("Failed to read an inbound message:\n" + ByteBufUtil.hexDump((ByteBuf)byteBuf) + "\n");
    }
}

