/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SslContext;
import java.net.SocketAddress;
import java.time.Duration;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.transport.BoltProtocolFactory;
import org.neo4j.bolt.transport.NettyServer;
import org.neo4j.bolt.transport.TransportSelectionHandler;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.transport.pipeline.ChannelProtector;
import org.neo4j.bolt.transport.pipeline.UnauthenticatedChannelProtector;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryTracker;

public class SocketTransport
implements NettyServer.ProtocolInitializer {
    private final String connector;
    private final SocketAddress address;
    private final SslContext sslCtx;
    private final boolean encryptionRequired;
    private final LogProvider logging;
    private final TransportThrottleGroup throttleGroup;
    private final BoltProtocolFactory boltProtocolFactory;
    private final NetworkConnectionTracker connectionTracker;
    private final Duration channelTimeout;
    private final long maxMessageSize;
    private final ByteBufAllocator allocator;
    private final MemoryPool memoryPool;

    public SocketTransport(String connector, SocketAddress address, SslContext sslCtx, boolean encryptionRequired, LogProvider logging, TransportThrottleGroup throttleGroup, BoltProtocolFactory boltProtocolFactory, NetworkConnectionTracker connectionTracker, Duration channelTimeout, long maxMessageSize, ByteBufAllocator allocator, MemoryPool memoryPool) {
        this.connector = connector;
        this.address = address;
        this.sslCtx = sslCtx;
        this.encryptionRequired = encryptionRequired;
        this.logging = logging;
        this.throttleGroup = throttleGroup;
        this.boltProtocolFactory = boltProtocolFactory;
        this.connectionTracker = connectionTracker;
        this.channelTimeout = channelTimeout;
        this.maxMessageSize = maxMessageSize;
        this.allocator = allocator;
        this.memoryPool = memoryPool;
    }

    @Override
    public ChannelInitializer<Channel> channelInitializer() {
        return new ChannelInitializer<Channel>(){

            public void initChannel(Channel ch) {
                ch.config().setAllocator(SocketTransport.this.allocator);
                LocalMemoryTracker memoryTracker = new LocalMemoryTracker(SocketTransport.this.memoryPool, 0L, 64L, null);
                ch.closeFuture().addListener(future -> memoryTracker.close());
                memoryTracker.allocateHeap(HeapEstimator.sizeOf((Object)ch));
                memoryTracker.allocateHeap(UnauthenticatedChannelProtector.SHALLOW_SIZE + BoltChannel.SHALLOW_SIZE);
                UnauthenticatedChannelProtector channelProtector = new UnauthenticatedChannelProtector(ch.pipeline(), SocketTransport.this.channelTimeout, SocketTransport.this.maxMessageSize, (MemoryTracker)memoryTracker);
                BoltChannel boltChannel = SocketTransport.this.newBoltChannel(ch, channelProtector, (MemoryTracker)memoryTracker);
                SocketTransport.this.connectionTracker.add((TrackedNetworkConnection)boltChannel);
                ch.closeFuture().addListener(future -> SocketTransport.this.connectionTracker.remove((TrackedNetworkConnection)boltChannel));
                SocketTransport.this.throttleGroup.install(ch, (MemoryTracker)memoryTracker);
                ch.closeFuture().addListener(future -> SocketTransport.this.throttleGroup.uninstall(ch));
                memoryTracker.allocateHeap(TransportSelectionHandler.SHALLOW_SIZE);
                TransportSelectionHandler transportSelectionHandler = new TransportSelectionHandler(boltChannel, SocketTransport.this.sslCtx, SocketTransport.this.encryptionRequired, false, SocketTransport.this.logging, SocketTransport.this.boltProtocolFactory, channelProtector, (MemoryTracker)memoryTracker);
                ch.pipeline().addLast(new ChannelHandler[]{transportSelectionHandler});
            }
        };
    }

    @Override
    public SocketAddress address() {
        return this.address;
    }

    private BoltChannel newBoltChannel(Channel ch, ChannelProtector channelProtector, MemoryTracker memoryTracker) {
        return new BoltChannel(this.connectionTracker.newConnectionId(this.connector), this.connector, ch, channelProtector);
    }
}

