/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.request;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.AccessMode;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.values.virtual.MapValue;

public abstract class TransactionInitiatingMessage
implements RequestMessage {
    private final MapValue meta;
    private final List<Bookmark> bookmarks;
    private final Duration txTimeout;
    private final AccessMode accessMode;
    private final Map<String, Object> txMetadata;

    TransactionInitiatingMessage() {
        this(MapValue.EMPTY, List.of(), null, AccessMode.WRITE, Map.of());
    }

    TransactionInitiatingMessage(MapValue meta, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata) {
        this.meta = meta;
        this.bookmarks = bookmarks;
        this.txTimeout = txTimeout;
        this.accessMode = accessMode;
        this.txMetadata = txMetadata;
    }

    public List<Bookmark> bookmarks() {
        return this.bookmarks;
    }

    public Duration transactionTimeout() {
        return this.txTimeout;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public Map<String, Object> transactionMetadata() {
        return this.txMetadata;
    }

    public MapValue meta() {
        return this.meta;
    }

    @Override
    public boolean safeToProcessInAnyState() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionInitiatingMessage that = (TransactionInitiatingMessage)o;
        return Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        return Objects.hash(this.meta);
    }
}

