/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.statemachine.impl;

import java.time.Clock;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.runtime.statemachine.StatementProcessor;
import org.neo4j.bolt.runtime.statemachine.StatementProcessorReleaseManager;
import org.neo4j.bolt.runtime.statemachine.TransactionStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.TransactionStateMachineSPIProvider;
import org.neo4j.bolt.runtime.statemachine.impl.TransactionStateMachine;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v41.messaging.RoutingContext;
import org.neo4j.memory.MemoryTracker;

public class StatementProcessorProvider {
    private final Clock clock;
    private final AuthenticationResult authResult;
    private final TransactionStateMachineSPIProvider spiProvider;
    private final StatementProcessorReleaseManager resourceReleaseManger;
    private final RoutingContext routingContext;
    private final MemoryTracker memoryTracker;

    public StatementProcessorProvider(AuthenticationResult authResult, TransactionStateMachineSPIProvider transactionSpiProvider, Clock clock, StatementProcessorReleaseManager releaseManager, RoutingContext routingContext, MemoryTracker memoryTracker) {
        this.authResult = authResult;
        this.spiProvider = transactionSpiProvider;
        this.clock = clock;
        this.resourceReleaseManger = releaseManager;
        this.routingContext = routingContext;
        this.memoryTracker = memoryTracker;
    }

    public StatementProcessor getStatementProcessor(String databaseName) throws BoltProtocolBreachFatality, BoltIOException {
        this.memoryTracker.allocateHeap(TransactionStateMachine.SHALLOW_SIZE);
        TransactionStateMachineSPI transactionSPI = this.spiProvider.getTransactionStateMachineSPI(databaseName, this.resourceReleaseManger);
        return new TransactionStateMachine(databaseName, transactionSPI, this.authResult, this.clock, this.routingContext);
    }

    public void releaseStatementProcessor() {
        this.memoryTracker.releaseHeap(TransactionStateMachine.SHALLOW_SIZE);
        this.spiProvider.releaseTransactionStateMachineSPI();
    }
}

