/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.statemachine.impl;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocolVersion;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineFactory;
import org.neo4j.bolt.runtime.statemachine.impl.BoltStateMachineSPIImpl;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.v3.BoltProtocolV3;
import org.neo4j.bolt.v3.BoltStateMachineV3;
import org.neo4j.bolt.v3.runtime.TransactionStateMachineSPIProviderV3;
import org.neo4j.bolt.v4.BoltProtocolV4;
import org.neo4j.bolt.v4.BoltStateMachineV4;
import org.neo4j.bolt.v4.runtime.TransactionStateMachineSPIProviderV4;
import org.neo4j.bolt.v41.BoltProtocolV41;
import org.neo4j.bolt.v41.BoltStateMachineV41;
import org.neo4j.bolt.v42.BoltProtocolV42;
import org.neo4j.bolt.v42.BoltStateMachineV42;
import org.neo4j.bolt.v43.BoltProtocolV43;
import org.neo4j.bolt.v43.BoltStateMachineV43;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class BoltStateMachineFactoryImpl
implements BoltStateMachineFactory {
    private final BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI;
    private final LogService logging;
    private final Authentication authentication;
    private final SystemNanoClock clock;
    private final DefaultDatabaseResolver defaultDatabaseResolver;

    public BoltStateMachineFactoryImpl(BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI, Authentication authentication, SystemNanoClock clock, Config config, LogService logging, DefaultDatabaseResolver defaultDatabaseResolver) {
        this.boltGraphDatabaseManagementServiceSPI = boltGraphDatabaseManagementServiceSPI;
        this.logging = logging;
        this.authentication = authentication;
        this.clock = clock;
        this.defaultDatabaseResolver = defaultDatabaseResolver;
    }

    @Override
    public BoltStateMachine newStateMachine(BoltProtocolVersion protocolVersion, BoltChannel boltChannel, MapValue connectionHints, MemoryTracker memoryTracker) {
        if (protocolVersion.equals(BoltProtocolV3.VERSION)) {
            return this.newStateMachineV3(boltChannel, connectionHints, memoryTracker);
        }
        if (protocolVersion.equals(BoltProtocolV4.VERSION)) {
            return this.newStateMachineV4(boltChannel, connectionHints, memoryTracker);
        }
        if (protocolVersion.equals(BoltProtocolV41.VERSION)) {
            return this.newStateMachineV41(boltChannel, connectionHints, memoryTracker);
        }
        if (protocolVersion.equals(BoltProtocolV42.VERSION)) {
            return this.newStateMachineV42(boltChannel, connectionHints, memoryTracker);
        }
        if (protocolVersion.equals(BoltProtocolV43.VERSION)) {
            return this.newStateMachineV43(boltChannel, connectionHints, memoryTracker);
        }
        throw new IllegalArgumentException("Failed to create a state machine for protocol version " + protocolVersion);
    }

    private BoltStateMachine newStateMachineV3(BoltChannel boltChannel, MapValue connectionHints, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(TransactionStateMachineSPIProviderV3.SHALLOW_SIZE + BoltStateMachineSPIImpl.SHALLOW_SIZE + BoltStateMachineV3.SHALLOW_SIZE);
        TransactionStateMachineSPIProviderV3 transactionSpiProvider = new TransactionStateMachineSPIProviderV3(this.boltGraphDatabaseManagementServiceSPI, boltChannel, this.clock, memoryTracker);
        BoltStateMachineSPIImpl boltSPI = new BoltStateMachineSPIImpl(this.logging, this.authentication, transactionSpiProvider, boltChannel);
        return new BoltStateMachineV3(boltSPI, boltChannel, (Clock)this.clock, this.defaultDatabaseResolver, connectionHints, memoryTracker);
    }

    private BoltStateMachine newStateMachineV4(BoltChannel boltChannel, MapValue connectionHints, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(TransactionStateMachineSPIProviderV4.SHALLOW_SIZE + BoltStateMachineSPIImpl.SHALLOW_SIZE + BoltStateMachineV4.SHALLOW_SIZE);
        TransactionStateMachineSPIProviderV4 transactionSpiProvider = new TransactionStateMachineSPIProviderV4(this.boltGraphDatabaseManagementServiceSPI, boltChannel, this.clock, memoryTracker);
        BoltStateMachineSPIImpl boltSPI = new BoltStateMachineSPIImpl(this.logging, this.authentication, transactionSpiProvider, boltChannel);
        return new BoltStateMachineV4(boltSPI, boltChannel, (Clock)this.clock, this.defaultDatabaseResolver, connectionHints, memoryTracker);
    }

    private BoltStateMachine newStateMachineV41(BoltChannel boltChannel, MapValue connectionHints, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(TransactionStateMachineSPIProviderV4.SHALLOW_SIZE + BoltStateMachineSPIImpl.SHALLOW_SIZE + BoltStateMachineV41.SHALLOW_SIZE);
        TransactionStateMachineSPIProviderV4 transactionSpiProvider = new TransactionStateMachineSPIProviderV4(this.boltGraphDatabaseManagementServiceSPI, boltChannel, this.clock, memoryTracker);
        BoltStateMachineSPIImpl boltSPI = new BoltStateMachineSPIImpl(this.logging, this.authentication, transactionSpiProvider, boltChannel);
        return new BoltStateMachineV41(boltSPI, boltChannel, (Clock)this.clock, this.defaultDatabaseResolver, connectionHints, memoryTracker);
    }

    private BoltStateMachine newStateMachineV42(BoltChannel boltChannel, MapValue connectionHints, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(TransactionStateMachineSPIProviderV4.SHALLOW_SIZE + BoltStateMachineSPIImpl.SHALLOW_SIZE + BoltStateMachineV42.SHALLOW_SIZE);
        TransactionStateMachineSPIProviderV4 transactionSpiProvider = new TransactionStateMachineSPIProviderV4(this.boltGraphDatabaseManagementServiceSPI, boltChannel, this.clock, memoryTracker);
        BoltStateMachineSPIImpl boltSPI = new BoltStateMachineSPIImpl(this.logging, this.authentication, transactionSpiProvider, boltChannel);
        return new BoltStateMachineV42(boltSPI, boltChannel, (Clock)this.clock, this.defaultDatabaseResolver, connectionHints, memoryTracker);
    }

    private BoltStateMachine newStateMachineV43(BoltChannel boltChannel, MapValue connectionHints, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(TransactionStateMachineSPIProviderV4.SHALLOW_SIZE + BoltStateMachineSPIImpl.SHALLOW_SIZE + BoltStateMachineV43.SHALLOW_SIZE);
        TransactionStateMachineSPIProviderV4 transactionSpiProvider = new TransactionStateMachineSPIProviderV4(this.boltGraphDatabaseManagementServiceSPI, boltChannel, this.clock, memoryTracker);
        BoltStateMachineSPIImpl boltSPI = new BoltStateMachineSPIImpl(this.logging, this.authentication, transactionSpiProvider, boltChannel);
        return new BoltStateMachineV43(boltSPI, boltChannel, (Clock)this.clock, this.defaultDatabaseResolver, connectionHints, memoryTracker);
    }
}

