/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v43.messaging;

import java.util.Arrays;
import java.util.List;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BookmarksParser;
import org.neo4j.bolt.transport.pipeline.ChannelProtector;
import org.neo4j.bolt.v3.messaging.MessageProcessingHandler;
import org.neo4j.bolt.v3.messaging.ResultHandler;
import org.neo4j.bolt.v3.messaging.decoder.CommitMessageDecoder;
import org.neo4j.bolt.v3.messaging.decoder.GoodbyeMessageDecoder;
import org.neo4j.bolt.v3.messaging.decoder.ResetMessageDecoder;
import org.neo4j.bolt.v3.messaging.decoder.RollbackMessageDecoder;
import org.neo4j.bolt.v4.messaging.BeginMessageDecoder;
import org.neo4j.bolt.v4.messaging.DiscardMessageDecoder;
import org.neo4j.bolt.v4.messaging.PullMessageDecoder;
import org.neo4j.bolt.v4.messaging.RunMessageDecoder;
import org.neo4j.bolt.v41.messaging.decoder.HelloMessageDecoder;
import org.neo4j.bolt.v43.messaging.decoder.RouteMessageDecoder;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.HeapEstimator;

public class BoltRequestMessageReaderV43
extends BoltRequestMessageReader {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOf(BoltRequestMessageReaderV43.class);

    public BoltRequestMessageReaderV43(BoltConnection connection, BoltResponseMessageWriter responseMessageWriter, BookmarksParser bookmarksParser, ChannelProtector channelProtector, LogService logService) {
        super(connection, BoltRequestMessageReaderV43.newSimpleResponseHandler(responseMessageWriter, connection, logService), BoltRequestMessageReaderV43.buildDecoders(connection, responseMessageWriter, bookmarksParser, logService), channelProtector);
    }

    private static List<RequestMessageDecoder> buildDecoders(BoltConnection connection, BoltResponseMessageWriter responseMessageWriter, BookmarksParser bookmarksParser, LogService logService) {
        ResultHandler resultHandler = new ResultHandler(responseMessageWriter, connection, BoltRequestMessageReaderV43.internalLog(logService));
        BoltResponseHandler defaultHandler = BoltRequestMessageReaderV43.newSimpleResponseHandler(responseMessageWriter, connection, logService);
        return Arrays.asList(new HelloMessageDecoder(defaultHandler), new RunMessageDecoder(defaultHandler, bookmarksParser), new DiscardMessageDecoder(resultHandler), new PullMessageDecoder(resultHandler), new BeginMessageDecoder(defaultHandler, bookmarksParser), new CommitMessageDecoder(resultHandler), new RollbackMessageDecoder(resultHandler), new ResetMessageDecoder(connection, defaultHandler), new GoodbyeMessageDecoder(connection, defaultHandler), new RouteMessageDecoder(defaultHandler, bookmarksParser));
    }

    private static BoltResponseHandler newSimpleResponseHandler(BoltResponseMessageWriter responseMessageWriter, BoltConnection connection, LogService logService) {
        return new MessageProcessingHandler(responseMessageWriter, connection, BoltRequestMessageReaderV43.internalLog(logService));
    }

    private static Log internalLog(LogService logService) {
        return logService.getInternalLog(BoltRequestMessageReaderV43.class);
    }
}

