/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.routing;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.neo4j.bolt.messaging.ResultConsumer;
import org.neo4j.bolt.routing.RoutingTableGetter;
import org.neo4j.bolt.runtime.AccessMode;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.bolt.runtime.statemachine.StatementMetadata;
import org.neo4j.bolt.runtime.statemachine.StatementProcessor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;

public class ProcedureRoutingTableGetter
implements RoutingTableGetter {
    private static final String GET_ROUTING_TABLE_STATEMENT = "CALL dbms.routing.getRoutingTable($routingContext, $databaseName)";
    private static final String ROUTING_CONTEXT_PARAM = "routingContext";
    private static final String DATABASE_NAME_PARAM = "databaseName";

    @Override
    public CompletableFuture<MapValue> get(StatementProcessor statementProcessor, MapValue routingContext, List<Bookmark> bookmarks, String databaseName) {
        MapValue params = this.getParams(routingContext, databaseName);
        CompletableFuture<MapValue> future = new CompletableFuture<MapValue>();
        try {
            StatementMetadata statementMetadata = statementProcessor.run(GET_ROUTING_TABLE_STATEMENT, params, bookmarks, null, AccessMode.READ, Map.of());
            statementProcessor.streamResult(statementMetadata.queryId(), new RoutingTableConsumer(future));
        }
        catch (Throwable throwable) {
            future.completeExceptionally(throwable);
        }
        return future;
    }

    private MapValue getParams(MapValue routingContext, String databaseName) {
        MapValueBuilder paramsBuilder = new MapValueBuilder();
        paramsBuilder.add(ROUTING_CONTEXT_PARAM, (AnyValue)routingContext);
        paramsBuilder.add(DATABASE_NAME_PARAM, (AnyValue)Values.stringOrNoValue((String)databaseName));
        return paramsBuilder.build();
    }

    private static class RoutingTableRecordConsumer
    implements BoltResult.RecordConsumer {
        private final CompletableFuture<MapValue> future;
        private final MapValueBuilder mapValueBuilder;
        private final List<String> fields;
        private Iterator<String> fieldsIt;

        private RoutingTableRecordConsumer(CompletableFuture<MapValue> future, String[] fields) {
            this.future = future;
            this.mapValueBuilder = new MapValueBuilder();
            this.fields = List.of(fields);
        }

        @Override
        public void addMetadata(String key, AnyValue value) {
        }

        @Override
        public void beginRecord(int numberOfFields) throws IOException {
            this.fieldsIt = this.fields.iterator();
        }

        @Override
        public void consumeField(AnyValue value) throws IOException {
            this.mapValueBuilder.add(this.fieldsIt.next(), value);
        }

        @Override
        public void endRecord() throws IOException {
            this.future.complete(this.mapValueBuilder.build());
        }

        @Override
        public void onError() throws IOException {
            this.future.completeExceptionally(new RuntimeException("Error processing the record"));
        }
    }

    private static class RoutingTableConsumer
    implements ResultConsumer {
        private final CompletableFuture<MapValue> future;

        private RoutingTableConsumer(CompletableFuture<MapValue> future) {
            this.future = future;
        }

        @Override
        public void consume(BoltResult result) throws Throwable {
            RoutingTableRecordConsumer consumer = new RoutingTableRecordConsumer(this.future, result.fieldNames());
            result.handleRecords(consumer, 1L);
        }

        @Override
        public boolean hasMore() {
            return false;
        }
    }
}

