/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.time.Duration;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocol;
import org.neo4j.bolt.BoltProtocolVersion;
import org.neo4j.bolt.dbapi.CustomBookmarkFormatParser;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineFactory;
import org.neo4j.bolt.transport.BoltProtocolFactory;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.transport.pipeline.ChannelProtector;
import org.neo4j.bolt.v3.BoltProtocolV3;
import org.neo4j.bolt.v4.BoltProtocolV4;
import org.neo4j.bolt.v4.runtime.bookmarking.BookmarksParserV4;
import org.neo4j.bolt.v41.BoltProtocolV41;
import org.neo4j.bolt.v42.BoltProtocolV42;
import org.neo4j.bolt.v43.BoltProtocolV43;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.time.SystemNanoClock;

public class DefaultBoltProtocolFactory
implements BoltProtocolFactory {
    private final BoltConnectionFactory connectionFactory;
    private final Config config;
    private final LogService logService;
    private final BoltStateMachineFactory stateMachineFactory;
    private final BookmarksParserV4 bookmarksParserV4;
    private final SystemNanoClock clock;
    private final Duration keepAliveInterval;
    private final TransportThrottleGroup throttleGroup;

    public DefaultBoltProtocolFactory(BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory, Config config, LogService logService, DatabaseIdRepository databaseIdRepository, CustomBookmarkFormatParser customBookmarkFormatParser, TransportThrottleGroup throttleGroup, SystemNanoClock clock, Duration keepAliveInterval) {
        this.connectionFactory = connectionFactory;
        this.stateMachineFactory = stateMachineFactory;
        this.config = config;
        this.logService = logService;
        this.bookmarksParserV4 = new BookmarksParserV4(databaseIdRepository, customBookmarkFormatParser);
        this.throttleGroup = throttleGroup;
        this.clock = clock;
        this.keepAliveInterval = keepAliveInterval;
    }

    @Override
    public BoltProtocol create(BoltProtocolVersion protocolVersion, BoltChannel channel, ChannelProtector channelProtector, MemoryTracker memoryTracker) {
        if (protocolVersion.equals(BoltProtocolV3.VERSION)) {
            return new BoltProtocolV3(channel, this.connectionFactory, this.stateMachineFactory, this.config, this.logService, this.throttleGroup, channelProtector, memoryTracker);
        }
        if (protocolVersion.equals(BoltProtocolV4.VERSION)) {
            return new BoltProtocolV4(channel, this.connectionFactory, this.stateMachineFactory, this.config, this.bookmarksParserV4, this.logService, this.throttleGroup, channelProtector, memoryTracker);
        }
        if (protocolVersion.equals(BoltProtocolV41.VERSION)) {
            return new BoltProtocolV41(channel, this.connectionFactory, this.stateMachineFactory, this.config, this.bookmarksParserV4, this.logService, this.throttleGroup, this.clock, this.keepAliveInterval, channelProtector, memoryTracker);
        }
        if (protocolVersion.equals(BoltProtocolV42.VERSION)) {
            return new BoltProtocolV42(channel, this.connectionFactory, this.stateMachineFactory, this.config, this.bookmarksParserV4, this.logService, this.throttleGroup, this.clock, this.keepAliveInterval, channelProtector, memoryTracker);
        }
        if (protocolVersion.equals(BoltProtocolV43.VERSION)) {
            return new BoltProtocolV43(channel, this.connectionFactory, this.stateMachineFactory, this.config, this.bookmarksParserV4, this.logService, this.throttleGroup, this.clock, this.keepAliveInterval, channelProtector, memoryTracker);
        }
        return null;
    }
}

