/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v42;

import java.time.Duration;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocolVersion;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.Neo4jPackV2;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BookmarksParser;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineFactory;
import org.neo4j.bolt.transport.AbstractBoltProtocol;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.v41.messaging.BoltRequestMessageReaderV41;
import org.neo4j.bolt.v41.messaging.BoltResponseMessageWriterV41;
import org.neo4j.logging.internal.LogService;
import org.neo4j.time.SystemNanoClock;

public class BoltProtocolV42
extends AbstractBoltProtocol {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(4, 2);
    private final SystemNanoClock clock;
    private final Duration keepAliveInterval;

    public BoltProtocolV42(BoltChannel channel, BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory, BookmarksParser bookmarksParser, LogService logging, TransportThrottleGroup throttleGroup, SystemNanoClock clock, Duration keepAliveInterval) {
        super(channel, connectionFactory, stateMachineFactory, bookmarksParser, logging, throttleGroup);
        this.clock = clock;
        this.keepAliveInterval = keepAliveInterval;
    }

    @Override
    protected Neo4jPack createPack() {
        return new Neo4jPackV2();
    }

    @Override
    protected BoltRequestMessageReader createMessageReader(BoltConnection connection, BoltResponseMessageWriter messageWriter, BookmarksParser bookmarksParser, LogService logging) {
        return new BoltRequestMessageReaderV41(connection, messageWriter, bookmarksParser, logging);
    }

    @Override
    protected BoltResponseMessageWriter createMessageWriter(Neo4jPack neo4jPack, LogService logging) {
        PackOutput output = this.createPackOutput();
        return new BoltResponseMessageWriterV41(neo4jPack, output, logging, this.clock, this.keepAliveInterval);
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }
}

