/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v41.messaging;

import java.io.IOException;
import java.time.Duration;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.messaging.ResponseMessage;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.packstream.PackProvider;
import org.neo4j.bolt.v3.messaging.BoltResponseMessageWriterV3;
import org.neo4j.bolt.v41.messaging.MessageWriterTimer;
import org.neo4j.logging.internal.LogService;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.AnyValue;

public class BoltResponseMessageWriterV41
implements BoltResponseMessageWriter {
    private final BoltResponseMessageWriterV3 delegator;
    private final MessageWriterTimer timer;
    private boolean inRecord;
    private boolean shouldFlushAfterRecord;
    private boolean closed;

    public BoltResponseMessageWriterV41(PackProvider packerProvider, PackOutput output, LogService logService, SystemNanoClock clock, Duration keepAliveInterval) {
        this(new BoltResponseMessageWriterV3(packerProvider, output, logService), new MessageWriterTimer(clock, keepAliveInterval));
    }

    BoltResponseMessageWriterV41(BoltResponseMessageWriterV3 writer, MessageWriterTimer timer) {
        this.delegator = writer;
        this.timer = timer;
    }

    @Override
    public synchronized void write(ResponseMessage message) throws IOException {
        this.delegator.write(message);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.timer.reset();
        this.delegator.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keepAlive() throws IOException {
        if (!this.closed && this.timer.isTimedOut()) {
            BoltResponseMessageWriterV41 boltResponseMessageWriterV41 = this;
            synchronized (boltResponseMessageWriterV41) {
                if (!this.closed && this.timer.isTimedOut()) {
                    if (this.inRecord) {
                        this.shouldFlushAfterRecord = true;
                        return;
                    }
                    this.writeNoop();
                    this.flush();
                }
            }
        }
    }

    @Override
    public synchronized void initKeepAliveTimer() {
        this.timer.reset();
    }

    @Override
    public synchronized void beginRecord(int numberOfFields) throws IOException {
        this.beforeRecord();
        this.delegator.beginRecord(numberOfFields);
    }

    @Override
    public synchronized void consumeField(AnyValue value) throws IOException {
        this.delegator.consumeField(value);
    }

    @Override
    public synchronized void endRecord() throws IOException {
        this.delegator.endRecord();
        this.afterRecord();
    }

    @Override
    public synchronized void onError() throws IOException {
        this.delegator.onError();
        this.afterRecord();
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        this.delegator.close();
    }

    private void beforeRecord() {
        this.inRecord = true;
    }

    private void afterRecord() throws IOException {
        this.inRecord = false;
        if (this.shouldFlushAfterRecord) {
            this.flush();
        }
    }

    private void writeNoop() throws IOException {
        try {
            this.delegator.output().beginMessage();
            this.delegator.output().messageSucceeded();
        }
        catch (Throwable e) {
            this.delegator.log().error("Failed to write NOOP", e);
            throw e;
        }
    }
}

