/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.InterruptSignal;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v4.messaging.DiscardMessage;
import org.neo4j.bolt.v4.messaging.PullMessage;
import org.neo4j.util.Preconditions;

public class FailedState
implements BoltStateMachineState {
    private BoltStateMachineState interruptedState;

    @Override
    public BoltStateMachineState process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        this.assertInitialized();
        if (FailedState.shouldIgnore(message)) {
            context.connectionState().markIgnored();
            return this;
        }
        if (message instanceof InterruptSignal) {
            return this.interruptedState;
        }
        return null;
    }

    public void setInterruptedState(BoltStateMachineState interruptedState) {
        this.interruptedState = interruptedState;
    }

    protected void assertInitialized() {
        Preconditions.checkState((this.interruptedState != null ? 1 : 0) != 0, (String)"Interrupted state not set");
    }

    @Override
    public String name() {
        return "FAILED";
    }

    private static boolean shouldIgnore(RequestMessage message) {
        return message instanceof RunMessage || message instanceof PullMessage || message instanceof DiscardMessage || message instanceof CommitMessage || message instanceof RollbackMessage;
    }
}

