/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.runtime.statemachine.StatementProcessor;
import org.neo4j.bolt.v3.messaging.request.TransactionInitiatingMessage;
import org.neo4j.bolt.v4.messaging.BeginMessage;
import org.neo4j.bolt.v4.messaging.RunMessage;

public class ReadyState
extends org.neo4j.bolt.v3.runtime.ReadyState {
    @Override
    public BoltStateMachineState processUnsafe(RequestMessage message, StateMachineContext context) throws Exception {
        if (message instanceof RunMessage || message instanceof BeginMessage) {
            return super.processUnsafe(message, context);
        }
        return null;
    }

    @Override
    protected StatementProcessor getStatementProcessor(TransactionInitiatingMessage message, StateMachineContext context) throws BoltProtocolBreachFatality, BoltIOException {
        String databaseName;
        if (message instanceof RunMessage) {
            databaseName = ((RunMessage)message).databaseName();
        } else if (message instanceof BeginMessage) {
            databaseName = ((BeginMessage)message).databaseName();
        } else {
            throw new IllegalStateException("Expected either a BoltV4 RUN message or BEGIN message, but got: " + message.getClass());
        }
        return context.setCurrentStatementProcessorForDatabase(databaseName);
    }
}

